/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOUrl;
import org.basex.io.MimeTypes;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.Err;
import org.basex.query.value.item.B64Stream;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.StrStream;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNFetch
extends StandardFunc {
    public FNFetch(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _FETCH_TEXT: {
                return this.text(ctx);
            }
            case _FETCH_BINARY: {
                return this.binary(ctx);
            }
            case _FETCH_CONTENT_TYPE: {
                return this.contentType(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private StrStream text(QueryContext ctx) throws QueryException {
        byte[] uri = this.checkStr(this.expr[0], ctx);
        String enc = this.encoding(1, Err.BXFE_ENCODING, ctx);
        return new StrStream(IO.get(Token.string(uri)), enc, Err.BXFE_IO, ctx);
    }

    private B64Stream binary(QueryContext ctx) throws QueryException {
        byte[] uri = this.checkStr(this.expr[0], ctx);
        return new B64Stream(IO.get(Token.string(uri)), Err.BXFE_IO);
    }

    private Str contentType(QueryContext ctx) throws QueryException {
        String mt;
        byte[] uri = this.checkStr(this.expr[0], ctx);
        IO io = IO.get(Token.string(uri));
        String path = io.path();
        if (io instanceof IOUrl) {
            try {
                mt = ((IOUrl)io).connection().getContentType();
            }
            catch (IOException ex) {
                throw Err.BXFE_IO.get(this.info, ex);
            }
        } else if (io instanceof IOContent) {
            mt = "application/xml";
        } else {
            String string = mt = io.exists() ? MimeTypes.get(path) : null;
        }
        if (mt == null) {
            throw Err.BXFE_IO.get(this.info, new FileNotFoundException(path));
        }
        return Str.get(mt);
    }
}

