/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.basex.core.Databases;
import org.basex.core.GlobalOptions;
import org.basex.core.Perm;
import org.basex.core.cmd.Export;
import org.basex.core.cmd.Info;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.Rename;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.IndexType;
import org.basex.index.query.StringRange;
import org.basex.index.resource.Resources;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.MimeTypes;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IndexAccess;
import org.basex.query.expr.StringRangeAccess;
import org.basex.query.expr.ValueAccess;
import org.basex.query.func.FuncOptions;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.path.NameTest;
import org.basex.query.path.Test;
import org.basex.query.up.TransformModifier;
import org.basex.query.up.primitives.BackupCreate;
import org.basex.query.up.primitives.BackupDrop;
import org.basex.query.up.primitives.DBAdd;
import org.basex.query.up.primitives.DBAlter;
import org.basex.query.up.primitives.DBCopy;
import org.basex.query.up.primitives.DBCreate;
import org.basex.query.up.primitives.DBDelete;
import org.basex.query.up.primitives.DBDrop;
import org.basex.query.up.primitives.DBFlush;
import org.basex.query.up.primitives.DBOptimize;
import org.basex.query.up.primitives.DBRename;
import org.basex.query.up.primitives.DBRestore;
import org.basex.query.up.primitives.DBStore;
import org.basex.query.up.primitives.DeleteNode;
import org.basex.query.up.primitives.NewInput;
import org.basex.query.up.primitives.ReplaceValue;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Err;
import org.basex.query.util.IndexContext;
import org.basex.query.value.Value;
import org.basex.query.value.item.B64Stream;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.util.DateTime;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.QueryInput;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;
import org.basex.util.options.Options;

public final class FNDb
extends StandardFunc {
    private static final QNm Q_OPTIONS = QNm.get("options");
    private static final String SYSTEM = "system";
    private static final String DATABASE = "database";
    private static final String BACKUP = "backup";
    private static final String RESOURCE = "resource";
    private static final String RESOURCES = "resources";
    private static final String PATH = "path";
    private static final String RAW = "raw";
    private static final String SIZE = "size";
    private static final String CTYPE = "content-type";
    private static final String MDATE = "modified-date";

    public FNDb(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _DB_OPEN: {
                return this.open(ctx).iter();
            }
            case _DB_BACKUPS: {
                return this.backups(ctx);
            }
            case _DB_TEXT: {
                return this.valueAccess(true, ctx).iter(ctx);
            }
            case _DB_TEXT_RANGE: {
                return this.rangeAccess(true, ctx).iter(ctx);
            }
            case _DB_ATTRIBUTE: {
                return this.attribute(this.valueAccess(false, ctx), ctx, 2);
            }
            case _DB_ATTRIBUTE_RANGE: {
                return this.attribute(this.rangeAccess(false, ctx), ctx, 3);
            }
            case _DB_LIST: {
                return this.list(ctx);
            }
            case _DB_LIST_DETAILS: {
                return this.listDetails(ctx);
            }
            case _DB_NODE_ID: {
                return this.node(ctx, true);
            }
            case _DB_NODE_PRE: {
                return this.node(ctx, false);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _DB_OPEN: {
                return this.open(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _DB_ADD: {
                return this.add(ctx);
            }
            case _DB_ALTER: {
                return this.copy(ctx, false);
            }
            case _DB_CONTENT_TYPE: {
                return this.contentType(ctx);
            }
            case _DB_COPY: {
                return this.copy(ctx, true);
            }
            case _DB_CREATE: {
                return this.create(ctx);
            }
            case _DB_CREATE_BACKUP: {
                return this.createBackup(ctx);
            }
            case _DB_DELETE: {
                return this.delete(ctx);
            }
            case _DB_DROP: {
                return this.drop(ctx);
            }
            case _DB_DROP_BACKUP: {
                return this.dropBackup(ctx);
            }
            case _DB_EVENT: {
                return this.event(ctx);
            }
            case _DB_EXISTS: {
                return this.exists(ctx);
            }
            case _DB_EXPORT: {
                return this.export(ctx);
            }
            case _DB_FLUSH: {
                return this.flush(ctx);
            }
            case _DB_INFO: {
                return this.info(ctx);
            }
            case _DB_IS_RAW: {
                return this.isRaw(ctx);
            }
            case _DB_IS_XML: {
                return this.isXML(ctx);
            }
            case _DB_NAME: {
                return this.name(ctx);
            }
            case _DB_OPEN_ID: {
                return this.open(ctx, true);
            }
            case _DB_OPEN_PRE: {
                return this.open(ctx, false);
            }
            case _DB_OPTIMIZE: {
                return this.optimize(ctx);
            }
            case _DB_OUTPUT: {
                return this.output(ctx);
            }
            case _DB_PATH: {
                return this.path(ctx);
            }
            case _DB_RENAME: {
                return this.rename(ctx);
            }
            case _DB_REPLACE: {
                return this.replace(ctx);
            }
            case _DB_RESTORE: {
                return this.restore(ctx);
            }
            case _DB_RETRIEVE: {
                return this.retrieve(ctx);
            }
            case _DB_STORE: {
                return this.store(ctx);
            }
            case _DB_SYSTEM: {
                return FNDb.system(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Value open(QueryContext ctx) throws QueryException {
        Data data = this.checkData(ctx);
        String path = this.expr.length < 2 ? "" : this.path(1, ctx);
        return DBNodeSeq.get(data.resources.docs(path), data, true, path.isEmpty());
    }

    private DBNode open(QueryContext ctx, boolean id) throws QueryException {
        int pre;
        Data data = this.checkData(ctx);
        int v = (int)this.checkItr(this.expr[1], ctx);
        int n = pre = id ? data.pre(v) : v;
        if (pre < 0 || pre >= data.meta.size) {
            throw Err.BXDB_RANGE.get(this.info, this, v);
        }
        return new DBNode(data, pre);
    }

    private ValueAccess valueAccess(boolean text, QueryContext ctx) throws QueryException {
        IndexType it = text ? IndexType.TEXT : IndexType.ATTRIBUTE;
        return new ValueAccess(this.info, this.expr[1], it, new IndexContext(this.checkData(ctx), false));
    }

    private StringRangeAccess rangeAccess(boolean text, QueryContext ctx) throws QueryException {
        byte[] min = this.checkStr(this.expr[1], ctx);
        byte[] max = this.checkStr(this.expr[2], ctx);
        IndexType it = text ? IndexType.TEXT : IndexType.ATTRIBUTE;
        StringRange sr = new StringRange(it, min, true, max, true);
        return new StringRangeAccess(this.info, sr, new IndexContext(this.checkData(ctx), false));
    }

    private Iter attribute(final IndexAccess ia, final QueryContext ctx, int a) throws QueryException {
        NameTest nt;
        if (this.expr.length <= a) {
            return ia.iter(ctx);
        }
        QNm nm = new QNm(this.checkStr(this.expr[a], ctx), this.sc);
        if (!nm.hasPrefix()) {
            nm.uri(this.sc.ns.uri(Token.EMPTY));
        }
        if (!(nt = new NameTest(nm, Test.Kind.URI_NAME, true, this.sc.elemNS)).compile(ctx)) {
            return Empty.ITER;
        }
        return new NodeIter(){
            final NodeIter ir;
            {
                this.ir = ia.iter(ctx);
            }

            @Override
            public ANode next() throws QueryException {
                ANode n;
                while ((n = this.ir.next()) != null && !nt.eq(n)) {
                }
                return n;
            }
        };
    }

    private Iter list(QueryContext ctx) throws QueryException {
        final TokenList tl = new TokenList();
        int el = this.expr.length;
        if (el == 0) {
            for (String s : ctx.context.databases.listDBs()) {
                tl.add(s);
            }
        } else {
            Data data = this.checkData(ctx);
            String path = Token.string(el == 1 ? Token.EMPTY : this.checkStr(this.expr[1], ctx));
            Resources res = data.resources;
            IntList il = res.docs(path);
            int is = il.size();
            for (int i = 0; i < is; ++i) {
                tl.add(data.text(il.get(i), true));
            }
            for (byte[] file : res.binaries(path)) {
                tl.add(file);
            }
        }
        tl.sort(Prop.CASE);
        return new Iter(){
            int pos;

            @Override
            public Str get(long i) {
                return Str.get(tl.get((int)i));
            }

            @Override
            public Str next() {
                return (long)this.pos < this.size() ? this.get(this.pos++) : null;
            }

            @Override
            public boolean reset() {
                this.pos = 0;
                return true;
            }

            @Override
            public long size() {
                return tl.size();
            }
        };
    }

    private Iter backups(QueryContext ctx) throws QueryException {
        this.checkCreate(ctx);
        String name = this.expr.length == 0 ? null : Token.string(this.checkStr(this.expr[0], ctx));
        final StringList backups = name == null ? ctx.context.databases.backups() : ctx.context.databases.backups(name);
        final IOFile dbpath = ctx.context.globalopts.dbpath();
        return new Iter(){
            int up = -1;

            @Override
            public Item next() {
                if (++this.up >= backups.size()) {
                    return null;
                }
                String backup = backups.get(this.up);
                long length = new IOFile(dbpath, backup + ".zip").length();
                return new FElem(FNDb.BACKUP).add(backup).add(FNDb.SIZE, Token.token(length));
            }
        };
    }

    private Iter listDetails(QueryContext ctx) throws QueryException {
        if (this.expr.length == 0) {
            return this.listDBs(ctx);
        }
        final Data data = this.checkData(ctx);
        String path = Token.string(this.expr.length == 1 ? Token.EMPTY : this.checkStr(this.expr[1], ctx));
        final IntList il = data.resources.docs(path);
        final TokenList tl = data.resources.binaries(path);
        return new Iter(){
            final int is;
            final int ts;
            int ip;
            int tp;
            {
                this.is = il.size();
                this.ts = tl.size();
            }

            @Override
            public ANode get(long i) {
                if (i < (long)this.is) {
                    byte[] pt = data.text(il.get((int)i), true);
                    return FNDb.resource(pt, false, 0L, Token.token("application/xml"), data.meta.time);
                }
                if (i < (long)(this.is + this.ts)) {
                    byte[] pt = tl.get((int)i - this.is);
                    IOFile io = data.meta.binary(Token.string(pt));
                    return FNDb.resource(pt, true, io.length(), Token.token(MimeTypes.get(io.path())), io.timeStamp());
                }
                return null;
            }

            @Override
            public ANode next() {
                return this.ip < this.is ? this.get(this.ip++) : (this.tp < this.ts ? this.get(this.ip + this.tp++) : null);
            }

            @Override
            public boolean reset() {
                this.ip = 0;
                this.tp = 0;
                return true;
            }

            @Override
            public long size() {
                return this.ip + this.is;
            }
        };
    }

    private Iter listDBs(final QueryContext ctx) {
        final StringList sl = ctx.context.databases.listDBs();
        return new Iter(){
            int pos;

            @Override
            public ANode get(long i) throws QueryException {
                String name = sl.get((int)i);
                MetaData meta = new MetaData(name, ctx.context);
                try {
                    meta.read();
                }
                catch (IOException ex) {
                    throw Err.BXDB_OPEN.get(FNDb.this.info, ex);
                }
                FElem res = new FElem(FNDb.DATABASE);
                res.add(FNDb.RESOURCES, Token.token(meta.ndocs));
                res.add(FNDb.MDATE, DateTime.format(new Date(meta.dbtime()), DateTime.FULL));
                res.add(FNDb.SIZE, Token.token(meta.dbsize()));
                if (ctx.context.perm(Perm.CREATE, meta)) {
                    res.add(FNDb.PATH, meta.original);
                }
                res.add(name);
                return res;
            }

            @Override
            public ANode next() throws QueryException {
                return (long)this.pos < this.size() ? this.get(this.pos++) : null;
            }

            @Override
            public boolean reset() {
                this.pos = 0;
                return true;
            }

            @Override
            public long size() {
                return sl.size();
            }
        };
    }

    private Bln isRaw(QueryContext ctx) throws QueryException {
        Data data = this.checkData(ctx);
        String path = this.path(1, ctx);
        if (data.inMemory()) {
            return Bln.FALSE;
        }
        IOFile io = data.meta.binary(path);
        return Bln.get(io.exists() && !io.isDir());
    }

    private Bln exists(QueryContext ctx) throws QueryException {
        try {
            Data data = this.checkData(ctx);
            if (this.expr.length == 1) {
                return Bln.TRUE;
            }
            String path = this.path(1, ctx);
            boolean raw = false;
            if (!data.inMemory()) {
                IOFile io = data.meta.binary(path);
                raw = io.exists() && !io.isDir();
            }
            return Bln.get(raw || data.resources.doc(path) != -1);
        }
        catch (QueryException ex) {
            if (ex.err() == Err.BXDB_OPEN) {
                return Bln.FALSE;
            }
            throw ex;
        }
    }

    private Bln isXML(QueryContext ctx) throws QueryException {
        Data data = this.checkData(ctx);
        String path = this.path(1, ctx);
        return Bln.get(data.resources.doc(path) != -1);
    }

    private Str contentType(QueryContext ctx) throws QueryException {
        IOFile io;
        Data data = this.checkData(ctx);
        String path = this.path(1, ctx);
        int pre = data.resources.doc(path);
        if (pre != -1) {
            String mt = MimeTypes.get(Token.string(data.text(pre, true)));
            return Str.get(MimeTypes.isXML(mt) ? mt : "application/xml");
        }
        if (!data.inMemory() && (io = data.meta.binary(path)).exists() && !io.isDir()) {
            return Str.get(MimeTypes.get(path));
        }
        throw Err.WHICHRES.get(this.info, path);
    }

    private Item export(QueryContext ctx) throws QueryException {
        this.checkCreate(ctx);
        Data data = this.checkData(ctx);
        String path = Token.string(this.checkStr(this.expr[1], ctx));
        Item it = this.expr.length > 2 ? this.expr[2].item(ctx, this.info) : null;
        SerializerOptions sopts = FuncOptions.serializer(it, this.info);
        try {
            Export.export(data, path, sopts, null);
        }
        catch (IOException ex) {
            throw Err.SERANY.get(this.info, ex);
        }
        return null;
    }

    private Str name(QueryContext ctx) throws QueryException {
        return Str.get(this.checkDBNode((Item)this.checkItem((Expr)this.expr[0], (QueryContext)ctx)).data.meta.name);
    }

    private Str path(QueryContext ctx) throws QueryException {
        ANode node;
        ANode par = this.checkNode(this.expr[0], ctx);
        while ((par = (node = par).parent()) != null) {
        }
        DBNode dbn = this.checkDBNode(node);
        return Str.get(dbn.data.text(dbn.pre, true));
    }

    private static FNode resource(byte[] path, boolean raw, long size, byte[] ctype, long mdate) {
        String tstamp = DateTime.format(new Date(mdate), DateTime.FULL);
        FElem res = new FElem(RESOURCE).add(path).add(RAW, Token.token(raw)).add(CTYPE, ctype).add(MDATE, tstamp);
        return raw ? res.add(SIZE, Token.token(size)) : res;
    }

    private static ANode system(QueryContext ctx) {
        return FNDb.toNode(Info.info(ctx.context), SYSTEM);
    }

    private ANode info(QueryContext ctx) throws QueryException {
        Data data = this.checkData(ctx);
        boolean create = ctx.context.user.has(Perm.CREATE);
        return FNDb.toNode(InfoDB.db(data.meta, false, true, create), DATABASE);
    }

    private static ANode toNode(String str, String root) {
        FElem top = new FElem(root);
        FElem node = null;
        for (String l : str.split("\r\n?|\n")) {
            String[] cols = l.split(": ", 2);
            if (cols[0].isEmpty()) continue;
            FElem n = new FElem(Token.token(FNDb.toName(cols[0])));
            if (cols[0].startsWith(" ")) {
                if (node != null) {
                    node.add(n);
                }
                if (cols[1].isEmpty()) continue;
                n.add(cols[1]);
                continue;
            }
            node = n;
            top.add(n);
        }
        return top;
    }

    public static String toName(String str) {
        return str.replaceAll("[ -:]", "").toLowerCase(Locale.ENGLISH);
    }

    private Item add(QueryContext ctx) throws QueryException {
        Data data = this.checkData(ctx);
        byte[] path = this.expr.length < 3 ? Token.EMPTY : Token.token(this.path(2, ctx));
        NewInput input = this.checkInput(this.checkItem(this.expr[1], ctx), path);
        Options opts = this.checkOptions(3, Q_OPTIONS, new Options(), ctx);
        ctx.updates.add(new DBAdd(data, input, opts, ctx, this.info), ctx);
        return null;
    }

    private Item replace(QueryContext ctx) throws QueryException {
        IOFile bin;
        Data data = this.checkData(ctx);
        String path = this.path(1, ctx);
        NewInput input = this.checkInput(this.checkItem(this.expr[2], ctx), Token.token(path));
        Options opts = this.checkOptions(3, Q_OPTIONS, new Options(), ctx);
        Resources res = data.resources;
        IntList pre = res.docs(path, true);
        for (int p = 0; p < pre.size(); ++p) {
            ctx.updates.add(new DeleteNode(pre.get(p), data, this.info), ctx);
        }
        IOFile iOFile = bin = data.inMemory() ? null : data.meta.binary(path);
        if (bin != null) {
            if (bin.exists()) {
                if (bin.isDir()) {
                    throw Err.BXDB_DIR.get(this.info, path);
                }
                ctx.updates.add(new DBStore(data, path, input, this.info), ctx);
            } else {
                ctx.updates.add(new DBAdd(data, input, opts, ctx, this.info), ctx);
            }
        }
        return null;
    }

    private Item delete(QueryContext ctx) throws QueryException {
        Data data = this.checkData(ctx);
        String path = this.path(1, ctx);
        IntList docs = data.resources.docs(path);
        int is = docs.size();
        for (int i = 0; i < is; ++i) {
            ctx.updates.add(new DeleteNode(docs.get(i), data, this.info), ctx);
        }
        if (!data.inMemory()) {
            IOFile bin = data.meta.binary(path);
            if (bin == null) {
                throw Err.UPDBDELERR.get(this.info, path);
            }
            ctx.updates.add(new DBDelete(data, path, this.info), ctx);
        }
        return null;
    }

    private Item copy(QueryContext ctx, boolean keep) throws QueryException {
        String name = Token.string(this.checkStr(this.expr[0], ctx));
        String newname = Token.string(this.checkStr(this.expr[1], ctx));
        if (!Databases.validName(name)) {
            throw Err.BXDB_NAME.get(this.info, name);
        }
        if (!Databases.validName(newname)) {
            throw Err.BXDB_NAME.get(this.info, newname);
        }
        GlobalOptions goptions = ctx.context.globalopts;
        if (!goptions.dbexists(name)) {
            throw Err.BXDB_WHICH.get(this.info, name);
        }
        if (name.equals(newname)) {
            throw Err.BXDB_SAME.get(this.info, name, newname);
        }
        ctx.updates.add(keep ? new DBCopy(name, newname, this.info, ctx) : new DBAlter(name, newname, this.info, ctx), ctx);
        return null;
    }

    private Item create(QueryContext ctx) throws QueryException {
        String name = Token.string(this.checkStr(this.expr[0], ctx));
        if (!Databases.validName(name)) {
            throw Err.BXDB_NAME.get(this.info, name);
        }
        TokenList paths = new TokenList();
        if (this.expr.length > 2) {
            Item it;
            Iter ir = ctx.iter(this.expr[2]);
            while ((it = ir.next()) != null) {
                String path = Token.string(this.checkStr(it));
                String norm = MetaData.normPath(path);
                if (norm == null) {
                    throw Err.RESINV.get(this.info, path);
                }
                paths.add(norm);
            }
        }
        int ps = paths.size();
        ArrayList<NewInput> inputs = new ArrayList<NewInput>(ps);
        if (this.expr.length > 1) {
            Value val = ctx.value(this.expr[1]);
            long is = val.size();
            if (ps != 0 && is != (long)ps) {
                throw Err.BXDB_CREATEARGS.get(this.info, is, ps);
            }
            int i = 0;
            while ((long)i < is) {
                byte[] path = i < ps ? paths.get(i) : Token.EMPTY;
                inputs.add(this.checkInput(val.itemAt(i), path));
                ++i;
            }
        }
        Options opts = this.checkOptions(3, Q_OPTIONS, new Options(), ctx);
        ctx.updates.add(new DBCreate(name, inputs, opts, ctx, this.info), ctx);
        return null;
    }

    private Item drop(QueryContext ctx) throws QueryException {
        String name = Token.string(this.checkStr(this.expr[0], ctx));
        if (!Databases.validName(name)) {
            throw Err.BXDB_NAME.get(this.info, name);
        }
        if (!ctx.context.globalopts.dbexists(name)) {
            throw Err.BXDB_WHICH.get(this.info, name);
        }
        ctx.updates.add(new DBDrop(name, this.info, ctx), ctx);
        return null;
    }

    private Item createBackup(QueryContext ctx) throws QueryException {
        String name = Token.string(this.checkStr(this.expr[0], ctx));
        if (!Databases.validName(name)) {
            throw Err.BXDB_NAME.get(this.info, name);
        }
        if (!ctx.context.globalopts.dbexists(name)) {
            throw Err.BXDB_WHICH.get(this.info, name);
        }
        ctx.updates.add(new BackupCreate(name, this.info, ctx), ctx);
        return null;
    }

    private Item dropBackup(QueryContext ctx) throws QueryException {
        String name = Token.string(this.checkStr(this.expr[0], ctx));
        if (!Databases.validName(name)) {
            throw Err.BXDB_NAME.get(this.info, name);
        }
        StringList backups = ctx.context.databases.backups(name);
        if (backups.isEmpty()) {
            throw Err.BXDB_WHICHBACK.get(this.info, name);
        }
        for (String backup : backups) {
            ctx.updates.add(new BackupDrop(backup, this.info, ctx), ctx);
        }
        return null;
    }

    private Item restore(QueryContext ctx) throws QueryException {
        String name = Token.string(this.checkStr(this.expr[0], ctx));
        if (!Databases.validName(name)) {
            throw Err.BXDB_NAME.get(this.info, name);
        }
        StringList backups = ctx.context.databases.backups(name);
        if (backups.isEmpty()) {
            throw Err.BXDB_NOBACKUP.get(this.info, name);
        }
        String backup = backups.get(0);
        String db = Databases.name(backup);
        ctx.updates.add(new DBRestore(db, backup, ctx, this.info), ctx);
        return null;
    }

    private Item rename(QueryContext ctx) throws QueryException {
        Data data = this.checkData(ctx);
        String source = this.path(1, ctx);
        String target = this.path(2, ctx);
        IntList il = data.resources.docs(source);
        int is = il.size();
        for (int i = 0; i < is; ++i) {
            int pre = il.get(i);
            String trg = Rename.target(data, pre, source, target);
            if (trg.isEmpty() || trg.endsWith("/") || trg.endsWith(".")) {
                throw Err.BXDB_RENAME.get(this.info, trg);
            }
            ctx.updates.add(new ReplaceValue(pre, data, this.info, Token.token(trg)), ctx);
        }
        if (!data.inMemory()) {
            IOFile src = data.meta.binary(source);
            IOFile trg = data.meta.binary(target);
            if (src == null || trg == null) {
                throw Err.UPDBRENAMEERR.get(this.info, src);
            }
            ctx.updates.add(new DBRename(data, src.path(), trg.path(), this.info), ctx);
        }
        return null;
    }

    private Item optimize(QueryContext ctx) throws QueryException {
        Data data = this.checkData(ctx);
        boolean all = this.expr.length > 1 && this.checkBln(this.expr[1], ctx);
        Options opts = this.checkOptions(2, Q_OPTIONS, new Options(), ctx);
        ctx.updates.add(new DBOptimize(data, all, opts, ctx, this.info), ctx);
        return null;
    }

    private Item store(QueryContext ctx) throws QueryException {
        Data data = this.checkData(ctx);
        String path = this.path(1, ctx);
        if (data.inMemory()) {
            throw Err.BXDB_MEM.get(this.info, data.meta.name);
        }
        IOFile file = data.meta.binary(path);
        if (file == null || file.isDir()) {
            throw Err.RESINV.get(this.info, path);
        }
        Item it = this.checkItem(this.expr[2], ctx);
        ctx.updates.add(new DBStore(data, path, it, this.info), ctx);
        return null;
    }

    private Item flush(QueryContext ctx) throws QueryException {
        ctx.updates.add(new DBFlush(this.checkData(ctx), this.info), ctx);
        return null;
    }

    private B64Stream retrieve(QueryContext ctx) throws QueryException {
        Data data = this.checkData(ctx);
        String path = this.path(1, ctx);
        if (data.inMemory()) {
            throw Err.BXDB_MEM.get(this.info, data.meta.name);
        }
        IOFile file = data.meta.binary(path);
        if (file == null || !file.exists() || file.isDir()) {
            throw Err.WHICHRES.get(this.info, path);
        }
        return new B64Stream(file, Err.IOERR);
    }

    private Iter node(final QueryContext ctx, final boolean id) throws QueryException {
        return new Iter(){
            final Iter ir;
            {
                this.ir = ctx.iter(FNDb.this.expr[0]);
            }

            @Override
            public Int next() throws QueryException {
                Item it = this.ir.next();
                if (it == null) {
                    return null;
                }
                DBNode node = FNDb.this.checkDBNode(it);
                return Int.get(id ? (long)node.data.id(node.pre) : (long)node.pre);
            }
        };
    }

    private Item event(QueryContext ctx) throws QueryException {
        byte[] name = this.checkStr(this.expr[0], ctx);
        try {
            ArrayOutput ao = ctx.value(this.expr[1]).serialize();
            if (!ctx.context.events.notify(ctx.context, name, ao.toArray())) {
                throw Err.BXDB_EVENT.get(this.info, new Object[]{name});
            }
            return null;
        }
        catch (QueryIOException ex) {
            throw ex.getCause(this.info);
        }
    }

    private Item output(QueryContext ctx) throws QueryException {
        if (ctx.updates.mod instanceof TransformModifier) {
            throw Err.BASX_DBTRANSFORM.get(this.info, new Object[0]);
        }
        this.cache(ctx.iter(this.expr[0]), ctx.output, ctx);
        return null;
    }

    private NewInput checkInput(Item in, byte[] path) throws QueryException {
        NewInput ni = new NewInput();
        if (in.type.isNode()) {
            if (Token.endsWith(path, 46) || Token.endsWith(path, 47)) {
                throw Err.RESINV.get(this.info, new Object[]{path});
            }
            ANode nd = (ANode)in;
            byte[] name = path;
            if (name.length == 0) {
                int i;
                name = nd.baseURI();
                Data d = nd.data();
                int n = i = d == null || d.inMemory() ? Token.lastIndexOf(name, 47) : Token.indexOf(name, 47);
                if (i != -1) {
                    name = Token.substring(name, i + 1);
                }
                if (name.length == 0) {
                    throw Err.RESINV.get(this.info, new Object[]{name});
                }
            }
            if (nd.type != NodeType.DOC) {
                if (nd.type == NodeType.ATT) {
                    throw Err.UPDOCTYPE.get(this.info, nd);
                }
                nd = new FDoc(name).add(nd);
            }
            ni.node = nd;
            ni.path = name;
            return ni;
        }
        if (!in.type.isStringOrUntyped()) {
            throw Err.STRNODTYPE.get(this.info, this, in.type);
        }
        QueryInput qi = new QueryInput(Token.string(in.string(this.info)));
        if (!qi.input.exists()) {
            throw Err.WHICHRES.get(this.info, qi.original);
        }
        String name = Token.string(path);
        if (name.endsWith(".")) {
            throw Err.RESINV.get(this.info, new Object[]{path});
        }
        if (!name.endsWith("/") && (qi.input.isDir() || qi.input.isArchive())) {
            name = name + "/";
        }
        String target = "";
        int s = name.lastIndexOf(47);
        if (s != -1) {
            target = name.substring(0, s);
            name = name.substring(s + 1);
        }
        if (!name.isEmpty()) {
            qi.input.name(name);
        } else if (!(qi.input instanceof IOContent)) {
            name = qi.input.name();
        }
        if (name.isEmpty()) {
            throw Err.RESINV.get(this.info, new Object[]{path});
        }
        ni.io = qi.input;
        ni.dbname = Token.token(name);
        ni.path = Token.token(target);
        return ni;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        if (!FNDb.oneOf(this.sig, Function._DB_BACKUPS, Function._DB_NODE_ID, Function._DB_NODE_PRE, Function._DB_EVENT, Function._DB_OUTPUT, Function._DB_SYSTEM) && (this.expr.length == 0 ? !visitor.lock(null) : !this.dataLock(visitor))) {
            return false;
        }
        return super.accept(visitor);
    }

    @Override
    public boolean iterable() {
        return FNDb.oneOf(this.sig, Function._DB_OPEN) || super.iterable();
    }

    private String path(int i, QueryContext ctx) throws QueryException {
        String path = Token.string(this.checkStr(this.expr[i], ctx));
        String norm = MetaData.normPath(path);
        if (norm == null) {
            throw Err.RESINV.get(this.info, path);
        }
        return norm;
    }
}

