/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.data.FTMatch;
import org.basex.data.FTStringMatch;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTFilter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTUnit;
import org.basex.util.hash.IntObjMap;

public final class FTDistance
extends FTFilter {
    private Expr min;
    private Expr max;

    public FTDistance(InputInfo ii, FTExpr e, Expr mn, Expr mx, FTUnit u) {
        super(ii, e, u);
        this.min = mn;
        this.max = mx;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.min, this.max);
        super.checkUp();
    }

    @Override
    public FTExpr compile(QueryContext ctx, VarScope scp) throws QueryException {
        this.min = this.min.compile(ctx, scp);
        this.max = this.max.compile(ctx, scp);
        return super.compile(ctx, scp);
    }

    @Override
    protected boolean filter(QueryContext ctx, FTMatch mtc, FTLexer lex) throws QueryException {
        long mn = this.checkItr(this.min, ctx);
        long mx = this.checkItr(this.max, ctx);
        mtc.sort();
        FTMatch match = new FTMatch();
        FTStringMatch last = null;
        FTStringMatch first = null;
        for (FTStringMatch sm : mtc) {
            if (sm.exclude) {
                match.add(sm);
                continue;
            }
            if (first == null) {
                first = sm;
            } else {
                int d = this.pos(sm.start, lex) - this.pos(last.end, lex) - 1;
                if ((long)d < mn || (long)d > mx) {
                    return false;
                }
            }
            last = sm;
        }
        first.end = last.end;
        mtc.reset();
        mtc.add(first);
        mtc.add(match);
        return true;
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return this.min.has(flag) || this.max.has(flag) || super.has(flag);
    }

    @Override
    public boolean removable(Var v) {
        return this.min.removable(v) || this.max.removable(v) && super.removable(v);
    }

    @Override
    public VarUsage count(Var v) {
        return super.count(v).plus(VarUsage.sum(v, this.min, this.max));
    }

    @Override
    public FTExpr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        Expr mn = this.min.inline(ctx, scp, v, e);
        Expr mx = this.max.inline(ctx, scp, v, e);
        if (mn != null) {
            this.min = mn;
        }
        if (mx != null) {
            this.max = mx;
        }
        return FTDistance.inlineAll(ctx, scp, this.expr, v, e) || mn != null || mx != null ? this.optimize(ctx, scp) : null;
    }

    @Override
    public FTExpr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new FTDistance(this.info, (FTExpr)this.expr[0].copy(ctx, scp, (IntObjMap)vs), this.min.copy(ctx, scp, vs), this.max.copy(ctx, scp, vs), this.unit);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem("distance", this.min + "-" + this.max + ' ' + (Object)((Object)this.unit)), this.expr);
    }

    @Override
    public String toString() {
        return super.toString() + "distance" + "(" + this.min + '-' + this.max + ' ' + (Object)((Object)this.unit) + ")";
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && FTDistance.visitAll(visitor, this.min, this.max);
    }

    @Override
    public int exprSize() {
        int sz = 1;
        for (FTExpr e : this.expr) {
            sz += e.exprSize();
        }
        return this.min.exprSize() + this.max.exprSize() + sz;
    }
}

