/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.func.FNInfo;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.ByteList;

public final class TypeCase
extends Single {
    final Var var;
    private final SeqType[] types;

    public TypeCase(InputInfo ii, Var v, SeqType[] ts, Expr r) {
        super(ii, r);
        this.var = v;
        this.types = ts;
    }

    @Override
    public TypeCase compile(QueryContext ctx, VarScope scp) throws QueryException {
        return this.compile(ctx, scp, null);
    }

    TypeCase compile(QueryContext ctx, VarScope scp, Value v) throws QueryException {
        Value val = this.var != null && v != null ? this.var.checkType(v, ctx, this.info, true) : null;
        try {
            Expr inlined;
            super.compile(ctx, scp);
            if (val != null && (inlined = this.expr.inline(ctx, scp, this.var, val)) != null) {
                this.expr = inlined;
            }
        }
        catch (QueryException ex) {
            this.expr = FNInfo.error(ex, this.expr.type());
        }
        this.type = this.expr.type();
        return this;
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) {
        try {
            return super.inline(ctx, scp, v, e);
        }
        catch (QueryException qe) {
            this.expr = FNInfo.error(qe, this.expr.type());
            return this;
        }
    }

    @Override
    public TypeCase copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        Var v;
        Var var = v = this.var == null ? null : scp.newCopyOf(ctx, this.var);
        if (this.var != null) {
            vs.put(this.var.id, v);
        }
        return new TypeCase(this.info, v, (SeqType[])this.types.clone(), this.expr.copy(ctx, scp, vs));
    }

    public boolean matches(Value val) {
        if (this.types.length == 0) {
            return true;
        }
        for (SeqType t : this.types) {
            if (!t.instance(val)) continue;
            return true;
        }
        return false;
    }

    Iter iter(QueryContext ctx, Value seq) throws QueryException {
        if (!this.matches(seq)) {
            return null;
        }
        if (this.var == null) {
            return ctx.iter(this.expr);
        }
        ctx.set(this.var, seq, this.info);
        return ctx.value(this.expr).iter();
    }

    @Override
    public void plan(FElem plan) {
        FElem e = this.planElem(new Object[0]);
        if (this.types.length == 0) {
            e.add(this.planAttr(Token.token("default"), Token.TRUE));
        } else {
            byte[] or = new byte[]{32, 124, 32};
            ByteList bl = new ByteList();
            for (SeqType t : this.types) {
                if (!bl.isEmpty()) {
                    bl.add(or);
                }
                bl.add(Token.token(t.toString()));
            }
            e.add(this.planAttr(Token.token("type"), bl.toArray()));
        }
        if (this.var != null) {
            e.add(this.planAttr(QueryText.VAR, Token.token(this.var.toString())));
        }
        this.expr.plan(e);
        plan.add(e);
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder(this.types.length == 0 ? "default" : "case");
        if (this.var != null) {
            tb.add(32).add(this.var.toString());
            if (this.types.length != 0) {
                tb.add(32).add("as");
            }
        }
        if (this.types.length != 0) {
            for (int i = 0; i < this.types.length; ++i) {
                if (i > 0) {
                    tb.add(" |");
                }
                tb.add(32).add(this.types[i].toString());
            }
        }
        return tb.add(" return " + this.expr).toString();
    }

    @Override
    public void markTailCalls(QueryContext ctx) {
        this.expr.markTailCalls(ctx);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && (this.var == null || visitor.declared(this.var));
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }
}

