/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Catch;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Try
extends Single {
    private final Catch[] ctch;

    public Try(InputInfo ii, Expr t, Catch[] c) {
        super(ii, t);
        this.ctch = c;
    }

    @Override
    public void checkUp() throws QueryException {
        Expr[] tmp = new Expr[this.ctch.length + 1];
        tmp[0] = this.expr;
        for (int c = 0; c < this.ctch.length; ++c) {
            tmp[c + 1] = this.ctch[c].expr;
        }
        this.checkAllUp(tmp);
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        try {
            super.compile(ctx, scp);
            if (this.expr.isValue()) {
                return this.optPre(this.expr, ctx);
            }
        }
        catch (QueryException ex) {
            if (!ex.isCatchable()) {
                throw ex;
            }
            for (Catch c : this.ctch) {
                if (!c.matches(ex)) continue;
                return this.optPre(c.compile(ctx, scp).asExpr(ex, ctx, scp), ctx);
            }
            throw ex;
        }
        for (Catch c : this.ctch) {
            c.compile(ctx, scp);
        }
        this.type = this.expr.type();
        for (Catch c : this.ctch) {
            if (c.expr.isFunction(Function.ERROR)) continue;
            this.type = this.type.union(c.type());
        }
        return this;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        try {
            return ctx.value(this.expr);
        }
        catch (QueryException ex) {
            if (!ex.isCatchable()) {
                throw ex;
            }
            for (Catch c : this.ctch) {
                if (!c.matches(ex)) continue;
                return c.value(ctx, ex);
            }
            throw ex;
        }
    }

    @Override
    public VarUsage count(Var v) {
        return VarUsage.maximum(v, this.ctch).plus(this.expr.count(v));
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        boolean change = false;
        try {
            Expr sub = this.expr.inline(ctx, scp, v, e);
            if (sub != null) {
                if (sub.isValue()) {
                    return this.optPre(sub, ctx);
                }
                this.expr = sub;
                change = true;
            }
        }
        catch (QueryException qe) {
            if (!qe.isCatchable()) {
                throw qe;
            }
            for (Catch c : this.ctch) {
                if (!c.matches(qe)) continue;
                Catch nw = c.inline(ctx, scp, v, e);
                return this.optPre((nw == null ? c : nw).asExpr(qe, ctx, scp), ctx);
            }
            throw qe;
        }
        for (Catch c : this.ctch) {
            change |= c.inline(ctx, scp, v, e) != null;
        }
        return change ? this : null;
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new Try(this.info, this.expr.copy(ctx, scp, vs), (Catch[])Arr.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.ctch));
    }

    @Override
    public boolean has(Expr.Flag flag) {
        for (Catch c : this.ctch) {
            if (!c.has(flag)) continue;
            return true;
        }
        return super.has(flag);
    }

    @Override
    public boolean removable(Var v) {
        for (Catch c : this.ctch) {
            if (c.removable(v)) continue;
            return false;
        }
        return super.removable(v);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.expr, this.ctch});
    }

    @Override
    public void markTailCalls(QueryContext ctx) {
        for (Catch c : this.ctch) {
            c.markTailCalls(ctx);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("try { " + this.expr + " }");
        for (Catch c : this.ctch) {
            sb.append(' ').append(c);
        }
        return sb.toString();
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && Try.visitAll(visitor, this.ctch);
    }

    @Override
    public int exprSize() {
        int sz = 1;
        for (Catch e : this.ctch) {
            sz += ((Expr)e).exprSize();
        }
        return sz;
    }
}

