/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.query.StringToken;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpR;
import org.basex.query.expr.CmpSR;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Context;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Pos;
import org.basex.query.expr.Union;
import org.basex.query.expr.ValueAccess;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.path.AxisPath;
import org.basex.query.path.Step;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.util.IndexCosts;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class CmpG
extends Cmp {
    OpG op;
    private ValueAccess[] va = new ValueAccess[0];
    private boolean atomic;

    public CmpG(Expr e1, Expr e2, OpG o, Collation coll, InputInfo ii) {
        super(ii, e1, e2, coll);
        this.op = o;
        this.type = SeqType.BLN;
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        super.compile(ctx, scp);
        return this.optimize(ctx, scp);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        if (this.swap()) {
            this.op = this.op.swap();
            ctx.compInfo("swapping operands: %", this);
        }
        boolean add = true;
        if (this.expr[1].isValue() && ((Value)this.expr[1]).type.isStringOrUntyped()) {
            Item it;
            Iter ir = this.expr[1].iter(ctx);
            while (add && (it = ir.next()) != null) {
                add = it.string(this.info).length != 0;
            }
        }
        if (add) {
            for (int e = 0; e != this.expr.length; ++e) {
                this.expr[e] = this.expr[e].addText(ctx);
            }
        }
        Expr e1 = this.expr[0];
        Expr e2 = this.expr[1];
        Expr e = this;
        if (this.oneIsEmpty()) {
            e = this.optPre(Bln.FALSE, ctx);
        } else if (this.allAreValues()) {
            e = this.preEval(ctx);
        } else if (e1.isFunction(Function.COUNT)) {
            e = this.compCount(this.op.op);
            if (e != this) {
                ctx.compInfo(e instanceof Bln ? "pre-evaluating %" : "rewriting %", this);
            }
        } else if (e1.isFunction(Function.POSITION)) {
            if (e2 instanceof RangeSeq && this.op.op == CmpV.OpV.EQ) {
                long p1 = ((Value)e2).itemAt(0L).itr(this.info);
                long p2 = p1 + e2.size() - 1L;
                e = Pos.get(p1, p2, this.info);
            } else {
                e = Pos.get(this.op.op, e2, e, this.info);
            }
            if (e != this) {
                ctx.compInfo("rewriting %", this);
            }
        } else if (e1.type().eq(SeqType.BLN) && (this.op == OpG.EQ && e2 == Bln.FALSE || this.op == OpG.NE && e2 == Bln.TRUE)) {
            e = Function.NOT.get(null, this.info, e1);
            ctx.compInfo("rewriting %", this);
        } else {
            e = CmpR.get(this);
            if (e == this) {
                e = CmpSR.get(this);
            }
            if (e != this) {
                ctx.compInfo("rewriting %", this);
            }
        }
        if (e != this) {
            return e;
        }
        boolean bl = this.atomic = e1.type().zeroOrOne() && e2.type().zeroOrOne();
        if (this.atomic) {
            ctx.compInfo("atomic evaluation of %", this);
        }
        return this;
    }

    @Override
    public Expr compEbv(QueryContext ctx) {
        return (this.op == OpG.EQ && this.expr[1] == Bln.TRUE || this.op == OpG.NE && this.expr[1] == Bln.FALSE) && this.expr[0].type().eq(SeqType.BLN) ? this.expr[0] : this;
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it2;
        Item it1;
        boolean s2;
        boolean s1;
        if (this.atomic) {
            Item it12 = this.expr[0].item(ctx, this.info);
            if (it12 == null) {
                return Bln.FALSE;
            }
            Item it22 = this.expr[1].item(ctx, this.info);
            if (it22 == null) {
                return Bln.FALSE;
            }
            return Bln.get(this.eval(it12, it22, this.collation));
        }
        Iter ir1 = ctx.iter(this.expr[0]);
        long is1 = ir1.size();
        if (is1 == 0L) {
            return Bln.FALSE;
        }
        boolean bl = s1 = is1 == 1L;
        if (s1 && this.expr[1].size() == 1L) {
            return Bln.get(this.eval(ir1.next(), this.expr[1].item(ctx, this.info), this.collation));
        }
        Iter ir2 = ctx.iter(this.expr[1]);
        long is2 = ir2.size();
        if (is2 == 0L) {
            return Bln.FALSE;
        }
        boolean bl2 = s2 = is2 == 1L;
        if (s1 && s2) {
            return Bln.get(this.eval(ir1.next(), ir2.next(), this.collation));
        }
        if (s2) {
            Item it13;
            Item it23 = ir2.next();
            while ((it13 = ir1.next()) != null) {
                if (!this.eval(it13, it23, this.collation)) continue;
                return Bln.TRUE;
            }
            return Bln.FALSE;
        }
        if (!ir2.reset()) {
            ValueBuilder vb = new ValueBuilder();
            it1 = ir1.next();
            if (it1 == null) {
                return Bln.FALSE;
            }
            while ((it2 = ir2.next()) != null) {
                if (this.eval(it1, it2, this.collation)) {
                    return Bln.TRUE;
                }
                vb.add(it2);
            }
            ir2 = vb;
        }
        while ((it1 = ir1.next()) != null) {
            ir2.reset();
            while ((it2 = ir2.next()) != null) {
                if (!this.eval(it1, it2, this.collation)) continue;
                return Bln.TRUE;
            }
        }
        return Bln.FALSE;
    }

    private boolean eval(Item a, Item b, Collation coll) throws QueryException {
        Type ta = a.type;
        Type tb = b.type;
        if (!(a instanceof FItem) && !(b instanceof FItem) && (ta == tb || ta.isUntyped() || tb.isUntyped() || a instanceof ANum && b instanceof ANum || a instanceof AStr && b instanceof AStr)) {
            return this.op.op.eval(a, b, coll, this.info);
        }
        throw Err.INVTYPECMP.get(this.info, ta, tb);
    }

    @Override
    public CmpG invert() {
        return this.expr[0].size() != 1L || this.expr[1].size() != 1L ? this : new CmpG(this.expr[0], this.expr[1], this.op.invert(), this.collation, this.info);
    }

    boolean union(CmpG g, QueryContext ctx, VarScope scp) throws QueryException {
        if (this.op != g.op || !this.expr[0].sameAs(g.expr[0])) {
            return false;
        }
        this.expr[1] = new List(this.info, this.expr[1], g.expr[1]).compile(ctx, scp);
        this.atomic = this.atomic && this.expr[1].type().zeroOrOne();
        return true;
    }

    @Override
    public boolean indexAccessible(IndexCosts ic) throws QueryException {
        Item it;
        boolean attr;
        Step s;
        if (this.op != OpG.EQ || this.collation != null) {
            return false;
        }
        Step step = s = this.expr[0] instanceof Context ? ic.step : CmpG.indexStep(this.expr[0]);
        if (s == null) {
            return false;
        }
        Data data = ic.ictx.data;
        boolean text = s.test.type == NodeType.TXT && data.meta.textindex;
        boolean bl = attr = s.test.type == NodeType.ATT && data.meta.attrindex;
        if (!text && !attr) {
            return false;
        }
        IndexType ind = text ? IndexType.TEXT : IndexType.ATTRIBUTE;
        Expr arg = this.expr[1];
        if (!arg.isValue()) {
            SeqType t = arg.type();
            if (!t.type.isStringOrUntyped() || arg.has(Expr.Flag.CTX) || arg.has(Expr.Flag.NDT)) {
                return false;
            }
            ic.addCosts(data.meta.size / 10);
            this.va = Array.add(this.va, new ValueAccess(this.info, arg, ind, ic.ictx));
            return true;
        }
        Iter ir = arg.iter(ic.ctx);
        ic.costs(0);
        while ((it = ir.next()) != null) {
            if (!it.type.isStringOrUntyped()) {
                return false;
            }
            int is = data.costs(new StringToken(ind, it.string(this.info)));
            if (is == 0) continue;
            this.va = Array.add(this.va, new ValueAccess(this.info, it, ind, ic.ictx));
            ic.addCosts(is);
        }
        return true;
    }

    @Override
    public Expr indexEquivalent(IndexCosts ic) {
        boolean text = this.va[0].itype == IndexType.TEXT;
        ic.ctx.compInfo(text ? "applying text index" : "applying attribute index", new Object[0]);
        ParseExpr root = this.va.length == 1 ? this.va[0] : new Union(this.info, this.va);
        return ic.invert(this.expr[0], root, text);
    }

    public static Step indexStep(Expr expr) {
        if (!(expr instanceof AxisPath)) {
            return null;
        }
        AxisPath path = (AxisPath)expr;
        return path.root != null ? null : path.step(path.steps.length - 1);
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        Expr a = this.expr[0].copy(ctx, scp, vs);
        Expr b = this.expr[1].copy(ctx, scp, vs);
        return new CmpG(a, b, this.op, this.collation, this.info);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.OP, this.op.name), this.expr);
    }

    @Override
    public String description() {
        return "'" + (Object)((Object)this.op) + "' operator";
    }

    @Override
    public String toString() {
        return this.toString(" " + (Object)((Object)this.op) + ' ');
    }

    public static enum OpG {
        LE("<=", CmpV.OpV.LE){

            @Override
            public OpG swap() {
                return GE;
            }

            @Override
            public OpG invert() {
                return LT;
            }
        }
        ,
        LT("<", CmpV.OpV.LT){

            @Override
            public OpG swap() {
                return GT;
            }

            @Override
            public OpG invert() {
                return GE;
            }
        }
        ,
        GE(">=", CmpV.OpV.GE){

            @Override
            public OpG swap() {
                return LE;
            }

            @Override
            public OpG invert() {
                return LT;
            }
        }
        ,
        GT(">", CmpV.OpV.GT){

            @Override
            public OpG swap() {
                return LT;
            }

            @Override
            public OpG invert() {
                return LE;
            }
        }
        ,
        EQ("=", CmpV.OpV.EQ){

            @Override
            public OpG swap() {
                return EQ;
            }

            @Override
            public OpG invert() {
                return NE;
            }
        }
        ,
        NE("!=", CmpV.OpV.NE){

            @Override
            public OpG swap() {
                return NE;
            }

            @Override
            public OpG invert() {
                return EQ;
            }
        };

        public static final OpG[] VALUES;
        public final String name;
        final CmpV.OpV op;

        private OpG(String n2, CmpV.OpV c) {
            this.name = n2;
            this.op = c;
        }

        public abstract OpG swap();

        public abstract OpG invert();

        public String toString() {
            return this.name;
        }

        static {
            VALUES = OpG.values();
        }
    }
}

