/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.CNode;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

public abstract class CName
extends CNode {
    private final String desc;
    Expr name;

    CName(String d, StaticContext sctx, InputInfo ii, Expr n, Expr ... v) {
        super(sctx, ii, v);
        this.name = n;
        this.desc = d;
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.name);
        super.checkUp();
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        this.name = this.name.compile(ctx, scp);
        return super.compile(ctx, scp);
    }

    final byte[] value(QueryContext ctx, InputInfo ii) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        for (Expr e : this.expr) {
            Item it;
            Iter ir = ctx.iter(e);
            boolean m = false;
            while ((it = ir.next()) != null) {
                if (m) {
                    tb.add(32);
                }
                tb.add(it.string(ii));
                m = true;
            }
        }
        return tb.finish();
    }

    final QNm qname(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = this.checkItem(this.name, ctx);
        Type ip = it.type;
        if (ip == AtomType.QNM) {
            return (QNm)it;
        }
        byte[] str = it.string(ii);
        if (XMLToken.isQName(str)) {
            return new QNm(str, this.sc);
        }
        throw (ip.isStringOrUntyped() ? Err.INVNAME : Err.INVQNAME).get(this.info, new Object[]{str});
    }

    @Override
    public boolean removable(Var v) {
        return this.name.removable(v) && super.removable(v);
    }

    @Override
    public final boolean has(Expr.Flag flag) {
        return this.name.has(flag) || super.has(flag);
    }

    @Override
    public final void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.name, this.expr});
    }

    @Override
    public final String description() {
        return CName.info(this.desc);
    }

    @Override
    public final String toString() {
        return this.toString(this.desc + (this.name.type().eq(SeqType.QNM) ? " " + this.name : " { " + this.name + " }"));
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        return this.name.accept(visitor) && CName.visitAll(visitor, this.expr);
    }

    @Override
    public final VarUsage count(Var v) {
        return this.name.count(v).plus(super.count(v));
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        boolean ex = CName.inlineAll(ctx, scp, this.expr, v, e);
        Expr sub = this.name.inline(ctx, scp, v, e);
        if (sub != null) {
            this.name = sub;
        }
        return sub != null || ex ? this.optimize(ctx, scp) : null;
    }

    @Override
    public final int exprSize() {
        int sz = 1;
        for (Expr e : this.expr) {
            sz += e.exprSize();
        }
        return sz + this.name.exprSize();
    }
}

