/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.IndexCosts;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public abstract class Arr
extends ParseExpr {
    public Expr[] expr;

    protected Arr(InputInfo info, Expr ... expr) {
        super(info);
        this.expr = expr;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.expr);
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        int es = this.expr.length;
        for (int e = 0; e < es; ++e) {
            this.expr[e] = this.expr[e].compile(ctx, scp);
        }
        return this;
    }

    @Override
    public boolean has(Expr.Flag flag) {
        for (Expr e : this.expr) {
            if (!e.has(flag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removable(Var v) {
        for (Expr e : this.expr) {
            if (e.removable(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public VarUsage count(Var v) {
        return VarUsage.sum(v, this.expr);
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        return Arr.inlineAll(ctx, scp, this.expr, v, e) ? this.optimize(ctx, scp) : null;
    }

    public static <T extends Expr> T[] copyAll(QueryContext ctx, VarScope scp, IntObjMap<Var> vs, T[] arr) {
        Expr[] copy = (Expr[])arr.clone();
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = copy[i].copy(ctx, scp, vs);
        }
        return copy;
    }

    @Override
    public Expr indexEquivalent(IndexCosts ic) throws QueryException {
        int es = this.expr.length;
        for (int e = 0; e < es; ++e) {
            this.expr[e] = this.expr[e].indexEquivalent(ic);
        }
        return this;
    }

    protected final boolean allAreValues() {
        for (Expr e : this.expr) {
            if (e.isValue()) continue;
            return false;
        }
        return true;
    }

    final boolean oneIsEmpty() {
        for (Expr e : this.expr) {
            if (!e.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), this.expr);
    }

    protected String toString(String sep) {
        return new TokenBuilder("(").addSep(this.expr, sep).add(")").toString();
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return Arr.visitAll(visitor, this.expr);
    }

    @Override
    public int exprSize() {
        int sz = 1;
        for (Expr e : this.expr) {
            sz += e.exprSize();
        }
        return sz;
    }
}

