/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import org.basex.data.ExprInfo;
import org.basex.io.IOContent;
import org.basex.io.in.NewlineInput;
import org.basex.query.QueryText;
import org.basex.query.Scope;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

public abstract class StaticScope
extends ExprInfo
implements Scope {
    public final StaticContext sc;
    protected final VarScope scope;
    public final InputInfo info;
    public Expr expr;
    protected boolean compiled;
    private final byte[] doc;

    StaticScope(VarScope scp, String xqdoc, StaticContext sctx, InputInfo ii) {
        this.sc = sctx;
        this.scope = scp;
        this.info = ii;
        this.doc = xqdoc != null && !xqdoc.isEmpty() ? Token.token(xqdoc) : null;
    }

    @Override
    public final boolean compiled() {
        return this.compiled;
    }

    public TokenObjMap<TokenList> doc() {
        if (this.doc == null) {
            return null;
        }
        TokenObjMap<TokenList> map = new TokenObjMap<TokenList>();
        byte[] key = null;
        TokenBuilder val = new TokenBuilder();
        TokenBuilder line = new TokenBuilder();
        try {
            NewlineInput nli = new NewlineInput(new IOContent(this.doc));
            while (nli.readLine(line)) {
                String l = line.toString().replaceAll("^\\s*: ?", "");
                if (l.startsWith("@")) {
                    StaticScope.add(key, val, map);
                    key = Token.token(l.replaceAll("^@(\\w*).*", "$1"));
                    l = l.replaceAll("^@\\w+ *", "");
                    val.reset();
                }
                val.add(l).add(10);
            }
        }
        catch (IOException ex) {
            throw Util.notExpected(ex);
        }
        StaticScope.add(key, val, map);
        return map;
    }

    private static void add(byte[] key, TokenBuilder val, TokenObjMap<TokenList> map) {
        byte[] k = key == null ? QueryText.DOC_TAGS[0] : key;
        TokenList tl = map.get(k);
        if (tl == null) {
            tl = new TokenList();
            map.put(k, tl);
        }
        tl.add(val.trim().finish());
    }
}

