/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.Arrays;
import java.util.IdentityHashMap;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.io.IO;
import org.basex.query.MainModule;
import org.basex.query.QueryContext;
import org.basex.query.QueryProcessor;
import org.basex.query.Scope;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.FuncItem;
import org.basex.query.var.StaticVar;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class QueryInfo {
    private final boolean verbose;
    public StringList readLocked;
    public StringList writeLocked;
    public long parsing;
    public long compiling;
    public long evaluating;
    public long serializing;
    public String query;
    boolean runtime;
    private final TokenList compile = new TokenList(0);
    private final TokenList evaluate = new TokenList(0);

    QueryInfo(QueryContext qc) {
        this.verbose = qc.context.options.get(MainOptions.QUERYINFO) != false || Prop.debug;
    }

    void compInfo(String string, Object ... ext) {
        if (this.verbose) {
            String info = Util.info(string, ext);
            if (this.runtime) {
                info = "RUNTIME: " + info;
                if (Prop.debug) {
                    Util.stack(info);
                }
            }
            this.compile.add(info);
        }
    }

    public void evalInfo(String string) {
        if (this.verbose) {
            this.evaluate.add(Token.token(string.replaceAll("\r?\n\\s*", " ")));
        }
    }

    public String toString(QueryProcessor qp, long printed, long hits, boolean detailed) {
        IO io;
        int runs = Math.max(1, qp.ctx.context.options.get(MainOptions.RUNS));
        TokenBuilder tb = new TokenBuilder();
        long total = this.parsing + this.compiling + this.evaluating + this.serializing;
        if (detailed) {
            int up = qp.updates();
            tb.add(this.toString(qp.ctx)).add(Text.NL);
            tb.add(Text.PARSING_CC).add(Performance.getTime(this.parsing, runs)).add(Text.NL);
            tb.add(Text.COMPILING_CC).add(Performance.getTime(this.compiling, runs)).add(Text.NL);
            tb.add(Text.EVALUATING_CC).add(Performance.getTime(this.evaluating, runs)).add(Text.NL);
            tb.add(Text.PRINTING_CC).add(Performance.getTime(this.serializing, runs)).add(Text.NL);
            tb.add(Text.TOTAL_TIME_CC).add(Performance.getTime(total, runs)).add(Text.NL).add(Text.NL);
            tb.add(Text.HITS_X_CC + hits).add(32).add(hits == 1L ? "Item" : "Items").add(Text.NL);
            tb.add(Text.UPDATED_CC + up).add(32).add(up == 1 ? "Item" : "Items").add(Text.NL);
            tb.add(Text.PRINTED_CC).add(Performance.format(printed)).add(Text.NL);
            tb.add(Text.READ_LOCKING_CC);
            if (this.readLocked == null) {
                tb.add("global");
            } else if (this.readLocked.isEmpty()) {
                tb.add("none");
            } else {
                tb.add("local").add(32).add(Arrays.toString(this.readLocked.toArray()));
            }
            tb.add(Text.NL).add(Text.WRITE_LOCKING_CC);
            if (this.writeLocked == null) {
                tb.add("global");
            } else if (this.writeLocked.isEmpty()) {
                tb.add("none");
            } else {
                tb.add("local").add(32).add(Arrays.toString(this.writeLocked.toArray()));
            }
            tb.add(Text.NL);
        }
        String name = (io = qp.sc.baseIO()) == null ? "" : " \"" + io.name() + '\"';
        tb.addExt(Text.NL + Text.QUERY_EXECUTED_X_X, name, Performance.getTime(total, runs));
        return tb.toString();
    }

    public String toString(QueryContext qc) {
        TokenBuilder tb = new TokenBuilder();
        if (this.query != null) {
            String qu = QueryProcessor.removeComments(this.query, Integer.MAX_VALUE);
            tb.add(Text.NL).add(Text.QUERY).add(":").add(Text.NL).add(qu).add(Text.NL);
        }
        if (!this.compile.isEmpty()) {
            tb.add(Text.NL).add(Text.COMPILING).add(":").add(Text.NL);
            for (byte[] line : this.compile) {
                tb.add("- ").add(line).add(Text.NL);
            }
            tb.add(Text.NL).add(Text.OPTIMIZED_QUERY).add(":").add(Text.NL);
            tb.add(qc.root == null ? qc.funcs.toString() : this.usedDecls(qc.root)).add(Text.NL);
        }
        if (!this.evaluate.isEmpty()) {
            tb.add(Text.NL).add(Text.EVALUATING).add(":").add(Text.NL);
            for (byte[] line : this.evaluate) {
                tb.add("- ").add(line).add(Text.NL);
            }
        }
        return tb.toString();
    }

    private String usedDecls(MainModule mod) {
        final IdentityHashMap map = new IdentityHashMap();
        final StringBuilder sb = new StringBuilder();
        mod.visit(new ASTVisitor(){

            @Override
            public boolean staticVar(StaticVar var) {
                if (map.put(var, var) == null) {
                    var.visit(this);
                    sb.append(var).append(Text.NL);
                }
                return true;
            }

            @Override
            public boolean staticFuncCall(StaticFuncCall call) {
                StaticFunc f = call.func();
                if (map.put(f, f) == null) {
                    f.visit(this);
                    sb.append(f).append(Text.NL);
                }
                return true;
            }

            @Override
            public boolean inlineFunc(Scope sub) {
                if (map.put(sub, sub) == null) {
                    sub.visit(this);
                }
                return true;
            }

            @Override
            public boolean funcItem(FuncItem func) {
                if (map.put(func, func) == null) {
                    func.visit(this);
                }
                return true;
            }
        });
        return sb.append(mod).toString();
    }
}

