/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.json;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.build.JsonOptions;
import org.basex.build.JsonSerialOptions;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.SerializerOptions;

public abstract class JsonSerializer
extends OutputSerializer {
    final JsonSerialOptions jopts;
    final JsonOptions.JsonSpec spec;
    private final boolean escape;

    JsonSerializer(OutputStream os, SerializerOptions opts) throws IOException {
        super(os, opts, new String[0]);
        this.jopts = opts.get(SerializerOptions.JSON);
        this.escape = this.jopts.get(JsonSerialOptions.ESCAPE);
        this.spec = this.jopts.get(JsonOptions.SPEC);
        if (this.jopts.contains(JsonSerialOptions.INDENT)) {
            this.indent = this.jopts.get(JsonSerialOptions.INDENT);
        }
    }

    @Override
    protected final void encode(int ch) throws IOException {
        if (this.escape) {
            switch (ch) {
                case 8: {
                    this.print("\\b");
                    break;
                }
                case 12: {
                    this.print("\\f");
                    break;
                }
                case 10: {
                    this.print("\\n");
                    break;
                }
                case 13: {
                    this.print("\\r");
                    break;
                }
                case 9: {
                    this.print("\\t");
                    break;
                }
                case 34: {
                    this.print("\\\"");
                    break;
                }
                case 92: {
                    this.print("\\\\");
                    break;
                }
                default: {
                    this.print(ch);
                    break;
                }
            }
        } else {
            this.print(ch);
        }
    }
}

