/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.json;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.json.JsonSerializer;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.util.Token;
import org.basex.util.Util;

public final class JsonMLSerializer
extends JsonSerializer {
    private boolean att;

    public JsonMLSerializer(OutputStream os, SerializerOptions opts) throws IOException {
        super(os, opts);
    }

    @Override
    protected void startOpen(byte[] name) throws IOException {
        if (this.level != 0) {
            this.print(44);
            this.indent();
        }
        this.print("[\"");
        for (byte ch : Token.local(name)) {
            this.encode(ch);
        }
        this.print(34);
        this.att = false;
    }

    @Override
    protected void attribute(byte[] name, byte[] value) throws IOException {
        this.print(",");
        if (this.indent) {
            this.print(32);
        }
        if (!this.att) {
            this.print("{");
            this.att = true;
        }
        this.print(34);
        for (byte ch : name) {
            this.encode(ch);
        }
        this.print("\":\"");
        for (byte ch : value) {
            this.encode(ch);
        }
        this.print("\"");
    }

    @Override
    protected void namespace(byte[] n, byte[] v) {
    }

    @Override
    protected void finishOpen() throws IOException {
        if (this.att) {
            this.print("}");
        }
    }

    @Override
    protected void finishText(byte[] text) throws IOException {
        this.print(44);
        this.indent();
        this.print(34);
        for (byte ch : text) {
            this.encode(ch);
        }
        this.print(34);
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.finishOpen();
        this.print(93);
    }

    @Override
    protected void finishClose() throws IOException {
        this.print(93);
    }

    @Override
    protected void finishComment(byte[] value) {
    }

    @Override
    protected void finishPi(byte[] name, byte[] value) {
    }

    @Override
    protected void atomic(Item value, boolean iter) throws IOException {
        JsonMLSerializer.error("Atomic values cannot be serialized", new Object[0]);
    }

    private static void error(String msg, Object ... ext) throws IOException {
        throw Err.BXJS_SERIAL.getIO(new Object[]{Util.inf(msg, ext)});
    }
}

