/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.util.Locale;
import org.basex.build.CsvOptions;
import org.basex.build.JsonSerialOptions;
import org.basex.io.serial.SerialMethod;
import org.basex.util.Prop;
import org.basex.util.options.EnumOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Options;
import org.basex.util.options.OptionsOption;
import org.basex.util.options.StringOption;

public final class SerializerOptions
extends Options {
    public static final EnumOption<YesNo> BYTE_ORDER_MARK = new EnumOption<YesNo>("byte-order-mark", YesNo.NO);
    public static final StringOption CDATA_SECTION_ELEMENTS = new StringOption("cdata-section-elements", "");
    public static final StringOption DOCTYPE_PUBLIC = new StringOption("doctype-public", "");
    public static final StringOption DOCTYPE_SYSTEM = new StringOption("doctype-system", "");
    public static final StringOption ENCODING = new StringOption("encoding", "UTF-8");
    public static final EnumOption<YesNo> ESCAPE_URI_ATTRIBUTES = new EnumOption<YesNo>("escape-uri-attributes", YesNo.NO);
    public static final EnumOption<YesNo> INCLUDE_CONTENT_TYPE = new EnumOption<YesNo>("include-content-type", YesNo.NO);
    public static final EnumOption<YesNo> INDENT = new EnumOption<YesNo>("indent", YesNo.YES);
    public static final StringOption SUPPRESS_INDENTATION = new StringOption("suppress-indentation", "");
    public static final StringOption MEDIA_TYPE = new StringOption("media-type", "");
    public static final EnumOption<SerialMethod> METHOD = new EnumOption<SerialMethod>("method", SerialMethod.XML);
    public static final EnumOption<Norm> NORMALIZATION_FORM = new EnumOption<Norm>("normalization-form", Norm.NFC);
    public static final EnumOption<YesNo> OMIT_XML_DECLARATION = new EnumOption<YesNo>("omit-xml-declaration", YesNo.YES);
    public static final EnumOption<YesNoOmit> STANDALONE = new EnumOption<YesNoOmit>("standalone", YesNoOmit.OMIT);
    public static final EnumOption<YesNo> UNDECLARE_PREFIXES = new EnumOption<YesNo>("undeclare-prefixes", YesNo.NO);
    public static final StringOption USE_CHARACTER_MAPS = new StringOption("use-character-maps", "");
    public static final StringOption ITEM_SEPARATOR = new StringOption("item-separator");
    public static final StringOption VERSION = new StringOption("version", "");
    public static final StringOption HTML_VERSION = new StringOption("html-version", "");
    public static final StringOption PARAMETER_DOCUMENT = new StringOption("parameter-document", "");
    public static final EnumOption<Newline> NEWLINE = new EnumOption<Newline>("newline", "\r".equals(Prop.NL) ? Newline.CR : ("\n".equals(Prop.NL) ? Newline.NL : Newline.CRNL));
    public static final EnumOption<YesNo> FORMAT = new EnumOption<YesNo>("format", YesNo.YES);
    public static final EnumOption<YesNo> TABULATOR = new EnumOption<YesNo>("tabulator", YesNo.NO);
    public static final NumberOption INDENTS = new NumberOption("indents", 2);
    public static final StringOption WRAP_PREFIX = new StringOption("wrap-prefix", "");
    public static final StringOption WRAP_URI = new StringOption("wrap-uri", "");
    public static final OptionsOption<CsvOptions> CSV = new OptionsOption<CsvOptions>("csv", new CsvOptions());
    public static final OptionsOption<JsonSerialOptions> JSON = new OptionsOption<JsonSerialOptions>("json", new JsonSerialOptions());
    public static final NumberOption LIMIT = new NumberOption("limit", -1);

    public boolean yes(EnumOption<YesNo> option) {
        return this.get(option) == YesNo.YES;
    }

    public static enum Newline {
        NL("\\n", "\n"),
        CR("\\r", "\r"),
        CRNL("\\r\\n", "\r\n");

        private final String name;
        private final String newline;

        private Newline(String n2, String nl) {
            this.name = n2;
            this.newline = nl;
        }

        String newline() {
            return this.newline;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Norm {
        NFC("NFC"),
        NONE("none");

        private final String string;

        private Norm(String s) {
            this.string = s;
        }

        public String toString() {
            return this.string;
        }
    }

    public static enum YesNoOmit {
        YES,
        NO,
        OMIT;


        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum YesNo {
        YES,
        NO;


        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

