/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.JsonOptions;
import org.basex.build.JsonParserOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.parse.json.JsonXmlConverter;
import org.basex.query.value.node.FElem;
import org.basex.util.Token;
import org.basex.util.XMLToken;

public final class JsonDirectConverter
extends JsonXmlConverter {
    private final boolean lax;
    private byte[] name = JsonConstants.JSON;

    public JsonDirectConverter(JsonParserOptions opts) {
        super(opts);
        this.lax = this.jopts.get(JsonOptions.LAX);
    }

    private FElem addElem(byte[] type) {
        FElem e = new FElem(this.name);
        this.addType(e, e.name(), type);
        if (this.elem != null) {
            this.elem.add(e);
        } else {
            this.elem = e;
        }
        this.name = null;
        return e;
    }

    @Override
    void openObject() {
        this.elem = this.addElem(JsonConstants.OBJECT);
    }

    @Override
    void openPair(byte[] key) {
        this.name = XMLToken.encode(key, this.lax);
    }

    @Override
    void closePair() {
    }

    @Override
    void closeObject() {
        FElem par = (FElem)this.elem.parent();
        if (par != null) {
            this.elem = par;
        }
    }

    @Override
    void openArray() {
        this.elem = this.addElem(JsonConstants.ARRAY);
    }

    @Override
    void openItem() {
        this.name = JsonConstants.VALUE;
    }

    @Override
    void closeItem() {
    }

    @Override
    void closeArray() {
        this.closeObject();
    }

    @Override
    public void openConstr(byte[] nm) {
        this.openObject();
        this.openPair(nm);
        this.openArray();
    }

    @Override
    public void openArg() {
        this.openItem();
    }

    @Override
    public void closeArg() {
        this.closeItem();
    }

    @Override
    public void closeConstr() {
        this.closeArray();
        this.closePair();
        this.closeObject();
    }

    @Override
    public void numberLit(byte[] value) {
        this.addElem(JsonConstants.NUMBER).add(value);
    }

    @Override
    public void stringLit(byte[] value) {
        this.addElem(JsonConstants.STRING).add(value);
    }

    @Override
    public void nullLit() {
        this.addElem(Token.NULL);
    }

    @Override
    public void booleanLit(byte[] b) {
        this.addElem(JsonConstants.BOOLEAN).add(b);
    }
}

