/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import java.util.ArrayList;
import org.basex.build.CsvParserOptions;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.Map;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

final class CsvMapConverter
extends CsvConverter {
    private static final byte[] ENTRY = Token.token("entry");
    private final TokenList headers = new TokenList();
    private final ArrayList<ValueBuilder> records = new ArrayList();
    private ValueBuilder record = new ValueBuilder();
    private int col;

    CsvMapConverter(CsvParserOptions opts) {
        super(opts);
    }

    @Override
    public void header(byte[] string) {
        this.headers.add(string);
    }

    @Override
    public void record() {
        this.record = new ValueBuilder();
        if (!this.headers.isEmpty()) {
            this.record.add(Map.EMPTY);
        }
        this.records.add(this.record);
        this.col = 0;
    }

    @Override
    public void entry(byte[] value) throws QueryIOException {
        if (this.headers.isEmpty()) {
            this.record.add(Str.get(value));
        } else {
            byte[] name;
            if ((name = this.headers.get(this.col++)) == null) {
                name = ENTRY;
            }
            try {
                this.record.set(((Map)this.record.get(0L)).insert(Str.get(name), Str.get(value), null), 0);
            }
            catch (QueryException ex) {
                throw new QueryIOException(ex);
            }
        }
    }

    @Override
    public Map finish() throws QueryIOException {
        try {
            Map map = Map.EMPTY;
            int row = 1;
            for (ValueBuilder vb : this.records) {
                map = map.insert(Int.get(row++), vb.value(), null);
            }
            return map;
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
    }
}

