/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import java.io.IOException;
import org.basex.build.CsvOptions;
import org.basex.build.CsvParserOptions;
import org.basex.io.IO;
import org.basex.io.in.NewlineInput;
import org.basex.io.parse.csv.CsvDirectConverter;
import org.basex.io.parse.csv.CsvMapConverter;
import org.basex.io.parse.csv.CsvParser;
import org.basex.query.QueryIOException;
import org.basex.query.value.item.Item;

public abstract class CsvConverter {
    private final CsvParserOptions copts;

    CsvConverter(CsvParserOptions opts) {
        this.copts = opts;
    }

    public void convert(IO input) throws IOException {
        String encoding = this.copts.get(CsvParserOptions.ENCODING);
        String csv = new NewlineInput(input).encoding(encoding).cache().toString();
        CsvParser.parse(csv, this.copts, this);
    }

    public static CsvConverter get(CsvParserOptions copts) {
        switch (copts.get(CsvOptions.FORMAT)) {
            case MAP: {
                return new CsvMapConverter(copts);
            }
        }
        return new CsvDirectConverter(copts);
    }

    abstract void header(byte[] var1);

    abstract void record();

    abstract void entry(byte[] var1) throws QueryIOException;

    public abstract Item finish() throws QueryIOException;
}

