/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.IOException;
import java.io.InputStream;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.io.in.EncodingException;
import org.basex.io.in.TextDecoder;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

public class TextInput
extends BufferInput {
    private TextDecoder decoder;
    private boolean valid;

    public TextInput(InputStream is) throws IOException {
        super(is);
        this.guess();
    }

    public TextInput(IO io) throws IOException {
        super(io);
        this.guess();
    }

    private void guess() throws IOException {
        try {
            int a = this.readByte();
            int b = this.readByte();
            int c = this.readByte();
            int d = this.readByte();
            String e = "UTF-8";
            int skip = 0;
            if (a == 255 && b == 254) {
                e = "UTF-16LE";
                skip = 2;
            } else if (a == 254 && b == 255) {
                e = "UTF-16BE";
                skip = 2;
            } else if (a == 239 && b == 187 && c == 191) {
                skip = 3;
            } else if (a == 60 && b == 0 && c == 63 && d == 0) {
                e = "UTF-16LE";
            } else if (a == 0 && b == 60 && c == 0 && d == 63) {
                e = "UTF-16BE";
            }
            this.reset();
            for (int s = 0; s < skip; ++s) {
                this.readByte();
            }
            this.decoder = TextDecoder.get(e);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public final String encoding() {
        return this.decoder.encoding;
    }

    public final TextInput validate(boolean v) {
        this.valid = v;
        this.decoder.valid = v;
        return this;
    }

    public TextInput encoding(String enc) throws IOException {
        if (enc != null) {
            String e = Token.normEncoding(enc);
            if (e == "UTF-16") {
                e = this.decoder.encoding == "UTF-16LE" ? "UTF-16LE" : "UTF-16BE";
            }
            this.decoder = TextDecoder.get(e);
            this.decoder.valid = this.valid;
        }
        return this;
    }

    @Override
    public int read() throws IOException {
        int ch = this.decoder.read(this);
        if (ch != -1 && this.valid && !XMLToken.valid(ch)) {
            throw new EncodingException(ch);
        }
        return ch;
    }

    @Override
    public final byte[] content() throws IOException {
        return this.cache().finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TokenBuilder cache() throws IOException {
        TokenBuilder tb = new TokenBuilder(Math.max(8, (int)this.length));
        try {
            int ch;
            while ((ch = this.read()) != -1) {
                tb.add(ch);
            }
        }
        finally {
            this.close();
        }
        return tb;
    }
}

