/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.stats;

import java.io.IOException;
import org.basex.data.MetaData;
import org.basex.index.stats.StatsType;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Token;
import org.basex.util.hash.TokenIntMap;

public final class Stats {
    public TokenIntMap cats;
    public StatsType type;
    public double min;
    public double max;
    public int count;
    private boolean leaf;

    public Stats() {
        this.cats = new TokenIntMap();
        this.type = StatsType.NONE;
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
        this.leaf = true;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setLeaf(boolean l) {
        this.leaf = l;
        if (!l) {
            this.type = StatsType.TEXT;
        }
    }

    public Stats(DataInput in) throws IOException {
        int k = in.readNum();
        this.type = StatsType.values()[k & 0xF];
        if (this.type == StatsType.INTEGER || this.type == StatsType.DOUBLE) {
            this.min = in.readDouble();
            this.max = in.readDouble();
        } else if (this.type == StatsType.CATEGORY) {
            if (k > 15) {
                this.cats = new TokenIntMap(in);
            } else {
                this.cats = new TokenIntMap();
                int cl = in.readNum();
                for (int i = 0; i < cl; ++i) {
                    this.cats.add(in.readToken());
                }
            }
        }
        this.count = in.readNum();
        this.leaf = in.readBool();
        in.readDouble();
    }

    public void write(DataOutput out) throws IOException {
        out.writeNum(this.type.ordinal() | 0x10);
        if (this.type == StatsType.INTEGER || this.type == StatsType.DOUBLE) {
            out.writeDouble(this.min);
            out.writeDouble(this.max);
        } else if (this.type == StatsType.CATEGORY) {
            this.cats.write(out);
        }
        out.writeNum(this.count);
        out.writeBool(this.leaf);
        out.writeDouble(0.0);
    }

    public void add(byte[] val, MetaData meta) {
        int vl = val.length;
        if (vl == 0 || this.type == StatsType.TEXT || Token.ws(val)) {
            return;
        }
        StatsType t = this.type;
        if (t == StatsType.NONE) {
            t = StatsType.INTEGER;
        }
        if (this.cats != null && this.cats.size() <= meta.maxcats) {
            if (val.length > meta.maxlen) {
                t = StatsType.TEXT;
                this.cats = null;
            } else {
                this.cats.put(val, Math.max(1, this.cats.get(val) + 1));
            }
        }
        if (t == StatsType.INTEGER) {
            long d = Token.toLong(val);
            if (d == Long.MIN_VALUE) {
                t = StatsType.DOUBLE;
            } else {
                if (this.min > (double)d) {
                    this.min = d;
                }
                if (this.max < (double)d) {
                    this.max = d;
                }
            }
        }
        if (t == StatsType.DOUBLE) {
            double d = Token.toDouble(val);
            if (Double.isNaN(d)) {
                t = this.cats.size() <= meta.maxcats ? StatsType.CATEGORY : StatsType.TEXT;
            } else {
                if (this.min > d) {
                    this.min = d;
                }
                if (this.max < d) {
                    this.max = d;
                }
            }
        } else if (t == StatsType.CATEGORY && this.cats.size() > meta.maxcats) {
            t = StatsType.TEXT;
            this.cats = null;
        }
        this.type = t;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.count + "x");
        switch (this.type) {
            case CATEGORY: {
                sb.append(", ").append(this.cats.size()).append(" values");
                break;
            }
            case DOUBLE: {
                sb.append(", numeric(").append(this.min).append(" - ").append(this.max).append(')');
                break;
            }
            case INTEGER: {
                sb.append(", numeric(").append((int)this.min).append(" - ").append((int)this.max).append(')');
                break;
            }
            case TEXT: {
                sb.append(", strings");
                break;
            }
        }
        if (this.leaf) {
            sb.append(", leaf");
        }
        return sb.toString();
    }
}

