/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.path;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.data.MetaData;
import org.basex.index.stats.Stats;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class PathNode {
    public final short name;
    public final byte kind;
    public final PathNode par;
    public PathNode[] ch;
    public final Stats stats;

    PathNode() {
        this(0, 0, null, 0);
    }

    private PathNode(int n, byte k, PathNode p) {
        this(n, k, p, 1);
    }

    private PathNode(int n, byte k, PathNode p, int c) {
        this.ch = new PathNode[0];
        this.name = (short)n;
        this.kind = k;
        this.par = p;
        this.stats = new Stats();
        this.stats.count = c;
    }

    PathNode(DataInput in, PathNode p) throws IOException {
        this.name = (short)in.readNum();
        this.kind = (byte)in.read();
        int s = in.readNum();
        this.ch = new PathNode[in.readNum()];
        if (in.readDouble() == 1.0) {
            this.stats = new Stats(in);
        } else {
            this.stats = new Stats();
            this.stats.count = s;
        }
        this.par = p;
        for (int i = 0; i < this.ch.length; ++i) {
            this.ch[i] = new PathNode(in, this);
        }
    }

    PathNode index(int n, byte k, byte[] v, MetaData md) {
        for (PathNode c : this.ch) {
            if (c.kind != k || c.name != n) continue;
            if (v != null) {
                c.stats.add(v, md);
            }
            ++c.stats.count;
            return c;
        }
        PathNode pn = new PathNode(n, k, this);
        if (v != null) {
            pn.stats.add(v, md);
        }
        int cs = this.ch.length;
        PathNode[] tmp = new PathNode[cs + 1];
        System.arraycopy(this.ch, 0, tmp, 0, cs);
        tmp[cs] = pn;
        this.ch = tmp;
        return pn;
    }

    void write(DataOutput out) throws IOException {
        out.writeNum(this.name);
        out.write1(this.kind);
        out.writeNum(0);
        out.writeNum(this.ch.length);
        out.writeDouble(1.0);
        boolean leaf = this.stats.isLeaf();
        for (PathNode c : this.ch) {
            leaf &= c.kind == 2 || c.kind == 3;
        }
        this.stats.setLeaf(leaf);
        this.stats.write(out);
        for (PathNode c : this.ch) {
            c.write(out);
        }
    }

    void addDesc(ArrayList<PathNode> nodes) {
        nodes.add(this);
        for (PathNode n : this.ch) {
            n.addDesc(nodes);
        }
    }

    void addDesc(ArrayList<PathNode> nodes, int n, int k) {
        if (n == this.name && k == this.kind) {
            nodes.add(this);
        }
        for (PathNode pn : this.ch) {
            pn.addDesc(nodes, n, k);
        }
    }

    public byte[] token(Data data) {
        switch (this.kind) {
            case 1: {
                return data.tagindex.key(this.name);
            }
            case 3: {
                return Token.concat(DataText.ATT, data.atnindex.key(this.name));
            }
            case 2: {
                return DataText.TEXT;
            }
            case 4: {
                return DataText.COMMENT;
            }
            case 5: {
                return DataText.PI;
            }
        }
        return Token.EMPTY;
    }

    public int level() {
        PathNode pn = this.par;
        int c = 0;
        while (pn != null) {
            pn = pn.par;
            ++c;
        }
        return c;
    }

    byte[] info(Data data, int l) {
        TokenBuilder tb = new TokenBuilder();
        if (l != 0) {
            tb.add(Text.NL);
        }
        for (int i = 0; i < l << 1; ++i) {
            tb.add(32);
        }
        switch (this.kind) {
            case 0: {
                tb.add(DataText.DOC);
                break;
            }
            case 1: {
                tb.add(data.tagindex.key(this.name));
                break;
            }
            case 2: {
                tb.add(DataText.TEXT);
                break;
            }
            case 3: {
                tb.add(DataText.ATT);
                tb.add(data.atnindex.key(this.name));
                break;
            }
            case 4: {
                tb.add(DataText.COMMENT);
                break;
            }
            case 5: {
                tb.add(DataText.PI);
            }
        }
        tb.add(": " + this.stats);
        for (PathNode p : this.ch) {
            tb.add(p.info(data, l + 1));
        }
        return tb.finish();
    }
}

