/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.basex.gui.view.project.ProjectFile;
import org.basex.gui.view.project.ProjectNode;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IOFile;

final class ProjectDir
extends ProjectNode {
    private static final Comparator<IOFile> COMP = new Comparator<IOFile>(){

        @Override
        public int compare(IOFile a, IOFile b) {
            return a.path().compareToIgnoreCase(b.path());
        }
    };

    ProjectDir(IOFile io, ProjectView proj) {
        super(io, proj);
        this.addDummy();
    }

    @Override
    void expand() {
        this.removeAllChildren();
        ArrayList<IOFile> dirs = new ArrayList<IOFile>();
        ArrayList files = new ArrayList();
        for (IOFile f : this.file.children()) {
            (f.isDir() ? dirs : files).add(f);
        }
        Collections.sort(dirs, COMP);
        Collections.sort(files, COMP);
        for (IOFile f : dirs) {
            this.add(new ProjectDir(f, this.project));
        }
        for (IOFile f : files) {
            this.add(new ProjectFile(f, this.project));
        }
    }

    @Override
    void collapse() {
        this.removeAllChildren();
        this.addDummy();
    }

    private void addDummy() {
        if (this.file.children().length != 0) {
            this.add(new ProjectFile(null, this.project));
        }
    }

    @Override
    public String toString() {
        String n = this.file.name();
        return n.isEmpty() ? this.file.file().getAbsolutePath() : n;
    }
}

