/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.basex.build.JsonParserOptions;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Execute;
import org.basex.core.cmd.Test;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.CommandParser;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIMenu;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXSplit;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.layout.GUICode;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.SearchBar;
import org.basex.gui.text.SearchEditor;
import org.basex.gui.text.TextPanel;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.editor.EditorArea;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.InputException;
import org.basex.io.in.NewlineInput;
import org.basex.io.in.TextInput;
import org.basex.io.parse.json.JsonConverter;
import org.basex.io.parse.xml.XmlParser;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryProcessor;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.BoolList;
import org.basex.util.list.StringList;
import org.xml.sax.SAXParseException;

public final class EditorView
extends View {
    private static final Pattern LINK = Pattern.compile("(.*?), ([0-9]+)/([0-9]+)");
    private static final int HISTORY = 18;
    private static final int HISTCOMP = 7;
    private final AbstractButton hist;
    private final AbstractButton stop;
    private final AbstractButton go;
    private final AbstractButton test;
    private final SearchBar search;
    private final BaseXLabel info;
    private final BaseXLabel pos;
    private final BaseXSplit split;
    private final BaseXLabel label;
    private final BaseXTabs tabs;
    private IOFile execFile;
    private int threadID;
    final ProjectView project;
    private InputInfo errorInfo;
    public final GUICode posCode = new GUICode(){

        @Override
        public void execute(Object arg) {
            int[] lc = EditorView.this.getEditor().pos();
            EditorView.this.pos.setText(lc[0] + " : " + lc[1]);
        }
    };

    public EditorView(ViewNotifier man) {
        super("editor", man);
        this.layout(new BorderLayout());
        this.label = new BaseXLabel(Text.EDITOR, true, false);
        this.label.setForeground(GUIConstants.GRAY);
        this.tabs = new BaseXTabs(this.gui);
        this.tabs.setFocusable(Prop.MAC);
        this.tabs.addDragDrop(false);
        this.addCreateTab();
        SearchEditor center = new SearchEditor(this.gui, this.tabs, null);
        this.search = center.bar();
        AbstractButton openB = BaseXButton.command(GUIMenuCmd.C_EDITOPEN, this.gui);
        final AbstractButton saveB = BaseXButton.get("c_save", Text.SAVE, false, this.gui);
        AbstractButton find = this.search.button(Text.FIND_REPLACE);
        this.hist = BaseXButton.get("c_hist", Text.RECENTLY_OPENED, false, this.gui);
        this.stop = BaseXButton.get("c_stop", Text.STOP, false, this.gui);
        this.stop.addKeyListener(this);
        this.stop.setEnabled(false);
        this.go = BaseXButton.get("c_go", BaseXLayout.addShortcut(Text.RUN_QUERY, BaseXKeys.EXEC1.toString()), false, this.gui);
        this.go.addKeyListener(this);
        this.test = BaseXButton.get("c_test", BaseXLayout.addShortcut(Text.RUN_TESTS, BaseXKeys.UNIT.toString()), false, this.gui);
        this.test.addKeyListener(this);
        BaseXBack buttons = new BaseXBack(GUIConstants.Fill.NONE);
        buttons.layout(new TableLayout(1, 8, 1, 0)).border(0, 0, 8, 0);
        buttons.add(openB);
        buttons.add(saveB);
        buttons.add(this.hist);
        buttons.add(find);
        buttons.add(Box.createHorizontalStrut(6));
        buttons.add(this.stop);
        buttons.add(this.go);
        buttons.add(this.test);
        BaseXBack north = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout());
        north.add((Component)buttons, "West");
        north.add((Component)this.label, "East");
        this.search.editor(this.addTab(), false);
        this.info = new BaseXLabel().setText("OK", GUIConstants.Msg.SUCCESS);
        this.pos = new BaseXLabel(" ");
        this.posCode.invokeLater();
        BaseXBack south = new BaseXBack(GUIConstants.Fill.NONE).border(10, 0, 2, 0);
        south.layout(new BorderLayout(4, 0));
        south.add((Component)this.info, "Center");
        south.add((Component)this.pos, "East");
        BaseXBack main = new BaseXBack().border(5).mode(GUIConstants.Fill.NONE);
        main.layout(new BorderLayout());
        main.add((Component)north, "North");
        main.add((Component)center, "Center");
        main.add((Component)south, "South");
        this.project = new ProjectView(this);
        this.split = new BaseXSplit(true);
        this.split.mode(GUIConstants.Fill.NONE);
        this.split.add(this.project);
        this.split.add(main);
        this.split.init(new double[]{0.3, 0.7}, new double[]{0.0, 1.0});
        this.project();
        this.add((Component)this.split, "Center");
        this.refreshLayout();
        saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu pop = new JPopupMenu();
                StringBuilder mnem = new StringBuilder();
                JMenuItem sa = GUIMenu.newItem(GUIMenuCmd.C_EDITSAVE, EditorView.this.gui, mnem);
                JMenuItem sas = GUIMenu.newItem(GUIMenuCmd.C_EDITSAVEAS, EditorView.this.gui, mnem);
                sa.setEnabled(GUIMenuCmd.C_EDITSAVE.enabled(EditorView.this.gui));
                sas.setEnabled(GUIMenuCmd.C_EDITSAVEAS.enabled(EditorView.this.gui));
                pop.add(sa);
                pop.add(sas);
                pop.show(saveB, 0, saveB.getHeight());
            }
        });
        this.hist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu pm = new JPopupMenu();
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ac) {
                        EditorView.this.open(new IOFile(ac.getActionCommand().replaceAll("(.*) \\[(.*)\\]", "$2/$1")));
                    }
                };
                StringList opened = new StringList();
                for (EditorArea ea : EditorView.this.editors()) {
                    opened.add(ea.file.path());
                }
                StringList hst = new StringList(18);
                StringList all = new StringList(EditorView.this.gui.gopts.get(GUIOptions.EDITOR));
                int fl = Math.min(all.size(), e == null ? 18 : 7);
                for (int f = 0; f < fl; ++f) {
                    hst.add(all.get(f));
                }
                Font f = null;
                for (String en : hst.sort(Prop.CASE)) {
                    JMenuItem it = new JMenuItem(en.replaceAll("(.*)[/\\\\](.*)", "$2 [$1]"));
                    if (opened.contains(en)) {
                        if (f == null) {
                            f = it.getFont().deriveFont(1);
                        }
                        it.setFont(f);
                    }
                    pm.add(it).addActionListener(al);
                }
                al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ac) {
                        EditorView.this.hist.getActionListeners()[0].actionPerformed(null);
                    }
                };
                if (e != null && pm.getComponentCount() == 7) {
                    pm.add(new JMenuItem("...")).addActionListener(al);
                }
                pm.show(EditorView.this.hist, 0, EditorView.this.hist.getHeight());
            }
        });
        this.refreshHistory(null);
        this.info.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EditorView.this.jumpToError();
            }
        });
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorView.this.stop.setEnabled(false);
                EditorView.this.go.setEnabled(false);
                EditorView.this.test.setEnabled(false);
                EditorView.this.gui.stop();
            }
        });
        this.go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorView.this.run(EditorView.this.getEditor(), TextPanel.Action.EXECUTE);
            }
        });
        this.test.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorView.this.run(EditorView.this.getEditor(), TextPanel.Action.TEST);
            }
        });
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EditorArea ea = EditorView.this.getEditor();
                if (ea == null) {
                    return;
                }
                EditorView.this.search.editor(ea, true);
                EditorView.this.gui.refreshControls();
                EditorView.this.posCode.invokeLater();
                EditorView.this.refreshMark();
                EditorView.this.run(ea, TextPanel.Action.PARSE);
            }
        });
        BaseXLayout.addDrop(this, new BaseXLayout.DropHandler(){

            @Override
            public void drop(Object file) {
                if (file instanceof File) {
                    EditorView.this.open(new IOFile((File)file));
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (String file : EditorView.this.gui.gopts.get(GUIOptions.OPEN)) {
                    EditorView.this.open(new IOFile(file), false, false);
                }
            }
        });
    }

    @Override
    public void refreshInit() {
    }

    @Override
    public void refreshFocus() {
    }

    @Override
    public void refreshMark() {
        boolean script = this.getEditor().script;
        this.go.setEnabled(script || this.gui.gopts.get(GUIOptions.EXECRT) == false);
        this.test.setEnabled(!script);
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
    }

    @Override
    public void refreshLayout() {
        this.label.border(-6, 0, 0, 2).setFont(GUIConstants.lfont);
        for (EditorArea edit : this.editors()) {
            edit.setFont(GUIConstants.mfont);
        }
        this.search.refreshLayout();
        Font ef = GUIConstants.font.deriveFont(7.0f + (float)(GUIConstants.fontSize >> 1));
        this.info.setFont(ef);
        this.pos.setFont(ef);
        this.project.refreshLayout();
    }

    @Override
    public void refreshUpdate() {
    }

    @Override
    public boolean visible() {
        return this.gui.gopts.get(GUIOptions.SHOWEDITOR);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gopts.set(GUIOptions.SHOWEDITOR, v);
    }

    @Override
    protected boolean db() {
        return false;
    }

    public void showProject() {
        if (!this.gui.gopts.get(GUIOptions.SHOWPROJECT).booleanValue()) {
            this.gui.gopts.invert(GUIOptions.SHOWPROJECT);
            this.split.visible(true);
        }
    }

    public void project() {
        boolean show = this.gui.gopts.get(GUIOptions.SHOWPROJECT);
        this.split.visible(show);
        if (show) {
            this.project.focus();
        } else {
            this.getEditor().requestFocusInWindow();
        }
    }

    public void findFiles() {
        this.project.findFiles(this.getEditor());
    }

    public void jumpToFile() {
        EditorArea editor = this.getEditor();
        if (editor.opened()) {
            this.project.jump(editor.file);
        }
    }

    public void tab(boolean next) {
        int s = this.tabs.getTabCount() - 1;
        int i = (s + this.tabs.getSelectedIndex() + (next ? 1 : -1)) % s;
        this.tabs.setSelectedIndex(i);
    }

    public void open() {
        BaseXFileChooser fc = new BaseXFileChooser(Text.OPEN, this.gui.gopts.get(GUIOptions.WORKPATH), this.gui);
        fc.filter("XQuery Files", IO.XQSUFFIXES);
        fc.filter("Command Scripts", ".bxs");
        fc.textFilters();
        for (IOFile f : fc.multi().selectAll(BaseXFileChooser.Mode.FOPEN)) {
            this.open(f);
        }
    }

    public void reopen() {
        this.getEditor().reopen(true);
    }

    public boolean save() {
        EditorArea edit = this.getEditor();
        return edit.opened() ? edit.save() : this.saveAs();
    }

    public boolean saveAs() {
        EditorArea edit = this.getEditor();
        String path = edit.opened() ? edit.file.path() : this.gui.gopts.get(GUIOptions.WORKPATH);
        BaseXFileChooser fc = new BaseXFileChooser(Text.SAVE_AS, path, this.gui);
        fc.filter("XQuery Files", IO.XQSUFFIXES);
        fc.filter("Command Scripts", ".bxs");
        fc.textFilters();
        fc.suffix(".xq");
        IOFile file = fc.select(BaseXFileChooser.Mode.FSAVE);
        if (file == null) {
            return false;
        }
        edit.save(file);
        return true;
    }

    public void newFile() {
        if (!this.visible()) {
            GUIMenuCmd.C_SHOWEDITOR.execute(this.gui);
        }
        this.refreshControls(this.addTab(), true);
    }

    public boolean delete(IOFile file) {
        EditorArea edit = this.find(file, true);
        if (edit != null) {
            this.close(edit);
        }
        return file.delete();
    }

    public EditorArea open(IOFile file) {
        return this.open(file, true, true);
    }

    private EditorArea open(IOFile file, boolean parse, boolean error) {
        EditorArea edit;
        if (!this.visible()) {
            GUIMenuCmd.C_SHOWEDITOR.execute(this.gui);
        }
        if ((edit = this.find(file, true)) != null) {
            this.tabs.setSelectedComponent(edit);
            edit.reopen(true);
        } else {
            try {
                byte[] text = this.read(file);
                if (text == null) {
                    return null;
                }
                edit = this.getEditor();
                if (edit.opened() || edit.modified) {
                    edit = this.addTab();
                }
                edit.initText(text);
                edit.file(file);
                if (parse) {
                    this.run(edit, TextPanel.Action.PARSE);
                }
            }
            catch (IOException ex) {
                this.refreshHistory(null);
                Util.debug(ex);
                if (error) {
                    BaseXDialog.error(this.gui, Util.info(Text.FILE_NOT_OPENED_X, file));
                }
                return null;
            }
        }
        return edit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(EditorArea editor, TextPanel.Action action) {
        boolean xquery;
        boolean run;
        this.refreshControls(editor, false);
        byte[] in = editor.getText();
        boolean eq = Token.eq(in, editor.last);
        if (eq && action == TextPanel.Action.CHECK) {
            return;
        }
        boolean bl = run = action == TextPanel.Action.EXECUTE || action == TextPanel.Action.TEST;
        if (run && this.gui.gopts.get(GUIOptions.SAVERUN).booleanValue()) {
            for (EditorArea edit : this.editors()) {
                if (!edit.opened()) continue;
                edit.save();
            }
        }
        IOFile file = editor.file;
        editor.last = in;
        boolean bl2 = xquery = file.hasSuffix(IO.XQSUFFIXES) || !file.path().contains(".");
        if (editor.script && run) {
            this.gui.execute(true, new Execute(Token.string(in)));
        } else if (xquery || run) {
            EditorArea ea;
            boolean exec;
            String input = in.length == 0 ? "()" : Token.string(in);
            boolean lib = QueryProcessor.isLibrary(input);
            boolean bl3 = exec = action == TextPanel.Action.EXECUTE || this.gui.gopts.get(GUIOptions.EXECRT) != false;
            if (exec && lib && (ea = this.execEditor()) != null) {
                file = ea.file;
                input = Token.string(ea.getText());
                lib = false;
            }
            this.gui.context.options.set(MainOptions.QUERYPATH, file.path());
            if (!lib && exec) {
                this.gui.execute(true, new XQuery(input));
                this.execFile = file;
            } else if (action == TextPanel.Action.TEST) {
                this.gui.execute(true, new Test(file.path()));
                this.execFile = file;
            } else {
                QueryContext qc = new QueryContext(this.gui.context);
                try {
                    qc.parse(input, lib, null, null);
                    this.info(null);
                }
                catch (QueryException ex) {
                    this.info(ex);
                }
                finally {
                    qc.close();
                }
            }
        } else if (file.hasSuffix(".json")) {
            try {
                IOContent io = new IOContent(in);
                io.name(file.path());
                JsonConverter.get(new JsonParserOptions()).convert(io);
                this.info(null);
            }
            catch (IOException ex) {
                this.info(ex);
            }
        } else if (editor.script || file.hasSuffix(IO.XMLSUFFIXES) || file.hasSuffix(IO.XSLSUFFIXES)) {
            ArrayInput ai = new ArrayInput(in);
            try {
                if (Token.startsWith(in, 60) || !editor.script) {
                    new XmlParser().parse(ai);
                }
                if (editor.script) {
                    new CommandParser(Token.string(in), this.gui.context).parse();
                }
                this.info(null);
            }
            catch (Exception ex) {
                this.info(ex);
            }
        } else if (action != TextPanel.Action.CHECK) {
            this.info(null);
        }
    }

    private void info(Exception ex) {
        this.info(ex, false, false);
    }

    private EditorArea execEditor() {
        if (this.execFile != null) {
            for (EditorArea edit : this.editors()) {
                if (!edit.file.path().equals(this.execFile.path())) continue;
                return edit;
            }
        }
        this.execFile = null;
        return null;
    }

    private byte[] read(IOFile file) throws IOException {
        TokenBuilder text = new TokenBuilder((int)Math.min(Integer.MAX_VALUE, file.length()));
        TextInput ti = new NewlineInput(file).validate(true);
        boolean valid = true;
        while (true) {
            int cp;
            block12: {
                cp = ti.read();
                if (cp != -1) break block12;
                byte[] byArray = text.array();
                ti.close();
                return byArray;
            }
            try {
                text.add(cp);
                continue;
            }
            catch (InputException ex) {
                block13: {
                    if (valid) {
                        valid = false;
                        Boolean binary = BaseXDialog.yesNoCancel(this.gui, Text.H_FILE_BINARY);
                        if (binary == null) {
                            byte[] byArray = null;
                            ti.close();
                            return byArray;
                        }
                        if (!binary.booleanValue()) break block13;
                        try {
                            file.open();
                        }
                        catch (IOException ioex) {
                            Desktop.getDesktop().open(file.file());
                        }
                        byte[] byArray = null;
                        ti.close();
                        return byArray;
                    }
                }
                try {
                    continue;
                }
                catch (Throwable throwable) {
                    ti.close();
                    throw throwable;
                }
            }
            break;
        }
    }

    void refreshHistory(IO file) {
        StringList paths = new StringList();
        if (file != null) {
            String path = file.path();
            this.gui.gopts.set(GUIOptions.WORKPATH, file.dirPath());
            paths.add(path);
            this.tabs.setToolTipTextAt(this.tabs.getSelectedIndex(), path);
        }
        String[] old = this.gui.gopts.get(GUIOptions.EDITOR);
        for (int p = 0; paths.size() < 18 && p < old.length; ++p) {
            IO fl = IO.get(old[p]);
            if (!fl.exists() || fl.eq(file)) continue;
            paths.add(fl.path());
        }
        this.gui.gopts.set(GUIOptions.EDITOR, paths.toArray());
        this.hist.setEnabled(!paths.isEmpty());
    }

    public boolean close(EditorArea edit) {
        EditorArea ea;
        EditorArea editorArea = ea = edit != null ? edit : this.getEditor();
        if (!this.confirm(ea)) {
            return false;
        }
        if (this.execFile != null && ea.file.path().equals(this.execFile.path())) {
            this.execFile = null;
        }
        this.tabs.remove(ea);
        int t = this.tabs.getTabCount();
        int i = this.tabs.getSelectedIndex();
        if (t == 1) {
            this.search.deactivate(true);
            this.addTab();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorView.this.project();
                }
            });
        } else if (i + 1 == t) {
            this.tabs.setSelectedIndex(i - 1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorView.this.getEditor().requestFocusInWindow();
                }
            });
        }
        return true;
    }

    public void start() {
        final int thread = this.threadID;
        new Thread(){

            @Override
            public void run() {
                Performance.sleep(200L);
                if (thread == EditorView.this.threadID) {
                    EditorView.this.info.setText(Text.PLEASE_WAIT_D, GUIConstants.Msg.SUCCESS).setToolTipText(null);
                    EditorView.this.stop.setEnabled(true);
                }
            }
        }.start();
    }

    public void info(Throwable th, boolean stopped, boolean refresh) {
        if (!refresh && this.stop.isEnabled()) {
            return;
        }
        ++this.threadID;
        this.getEditor().resetError();
        if (refresh) {
            this.stop.setEnabled(false);
            this.refreshMark();
        }
        if (stopped || th == null) {
            this.info.setCursor(GUIConstants.CURSORARROW);
            this.info.setText(stopped ? Text.INTERRUPTED : "OK", GUIConstants.Msg.SUCCESS);
            this.info.setToolTipText(null);
            this.errorInfo = null;
        } else {
            this.info.setCursor(GUIConstants.CURSORHAND);
            this.info.setText(th.getLocalizedMessage(), GUIConstants.Msg.ERROR);
            String tt = th.getMessage().replace("<", "&lt;").replace(">", "&gt;").replaceAll("\r?\n", "<br/>").replaceAll("(<br/>.*?)<br/>.*", "$1");
            this.info.setToolTipText("<html>" + tt + "</html>");
            if (th instanceof QueryIOException) {
                this.errorInfo = ((QueryIOException)th).getCause().info();
            } else if (th instanceof QueryException) {
                this.errorInfo = ((QueryException)th).info();
            } else if (th instanceof SAXParseException) {
                SAXParseException ex = (SAXParseException)th;
                String path = this.getEditor().file.path();
                this.errorInfo = new InputInfo(path, ex.getLineNumber(), ex.getColumnNumber());
            } else {
                this.errorInfo = new InputInfo(this.getEditor().file.path(), 1, 1);
            }
            this.error(false);
        }
    }

    public void jumpToError() {
        this.error(true);
    }

    public void jump(String link) {
        Matcher m = LINK.matcher(link);
        if (m.matches()) {
            this.errorInfo = new InputInfo(m.group(1), Token.toInt(m.group(2)), Token.toInt(m.group(3)));
            this.error(true);
        } else {
            Util.stack("No match found: " + link);
        }
    }

    private void error(boolean jump) {
        InputInfo ei = this.errorInfo;
        if (ei == null) {
            return;
        }
        IOFile file = new IOFile(ei.path());
        EditorArea edit = this.find(file, false);
        if (jump) {
            if (edit == null) {
                edit = this.open(file, false, true);
            }
            if (edit != null) {
                this.tabs.setSelectedComponent(edit);
            }
        }
        if (edit == null) {
            return;
        }
        int ep = EditorView.pos(edit.last, ei.line(), ei.column());
        edit.error(ep);
        if (jump) {
            edit.setCaret(ep);
            this.posCode.invokeLater();
        }
    }

    private static int pos(byte[] text, int line, int col) {
        int ll;
        int ep = ll = text.length;
        int l = 1;
        int c = 1;
        for (int p = 0; p < ll; p += Token.cl(text, p)) {
            if (l > line || l == line && c == col) {
                ep = p;
                break;
            }
            if (text[p] == 10) {
                ++l;
                c = 0;
            }
            ++c;
        }
        if (ep < ll && Character.isLetterOrDigit(Token.cp(text, ep))) {
            while (ep > 0 && Character.isLetterOrDigit(Token.cp(text, ep - 1))) {
                --ep;
            }
        }
        return ep;
    }

    public boolean confirm() {
        for (EditorArea edit : this.editors()) {
            this.tabs.setSelectedComponent(edit);
            if (this.confirm(edit)) continue;
            return false;
        }
        StringList files = new StringList();
        for (EditorArea edit : this.editors()) {
            if (!edit.opened()) continue;
            files.add(edit.file.path());
        }
        this.gui.gopts.set(GUIOptions.OPEN, files.toArray());
        return true;
    }

    public boolean modified() {
        EditorArea edit = this.getEditor();
        return edit.modified || !edit.opened();
    }

    public EditorArea getEditor() {
        Component c = this.tabs.getSelectedComponent();
        return c instanceof EditorArea ? (EditorArea)c : null;
    }

    public void rename(IOFile old, IOFile renamed) {
        try {
            boolean dir = renamed.isDir();
            String oldPath = old.file().getCanonicalPath() + (dir ? File.separator : "");
            int s = this.tabs.getTabCount() - 1;
            for (int i = 0; i < s; ++i) {
                Component c = this.tabs.getComponentAt(i);
                if (!(c instanceof EditorArea)) continue;
                EditorArea ea = (EditorArea)c;
                String editPath = ea.file.file().getCanonicalPath();
                if (dir) {
                    if (!editPath.startsWith(oldPath)) continue;
                    ea.file = new IOFile(renamed + File.separator + editPath.substring(oldPath.length()));
                    continue;
                }
                if (!oldPath.equals(editPath)) continue;
                ea.file = renamed;
                ea.label.setText(renamed.name());
                break;
            }
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
        }
    }

    void refreshControls(EditorArea edit, boolean force) {
        boolean oe = edit.modified;
        boolean bl = edit.modified = edit.hist != null && edit.hist.modified();
        if (edit.modified == oe && !force) {
            return;
        }
        String title = edit.file.name();
        if (edit.modified) {
            title = title + '*';
        }
        edit.label.setText(title);
        edit.script = edit.file.hasSuffix(".bxs");
        this.gui.refreshControls();
        this.posCode.invokeLater();
        this.refreshMark();
    }

    private EditorArea find(IO file, boolean opened) {
        for (EditorArea edit : this.editors()) {
            if (!edit.file.eq(file) || opened && !edit.opened()) continue;
            return edit;
        }
        return null;
    }

    private IOFile newTabFile() {
        BoolList bl = new BoolList();
        for (EditorArea edit : this.editors()) {
            if (edit.opened()) continue;
            String n = edit.file.name().substring(Text.FILE.length());
            bl.set(n.isEmpty() ? 1 : Integer.parseInt(n), true);
        }
        int c = 0;
        while (++c < bl.size() && bl.get(c)) {
        }
        return new IOFile(this.gui.gopts.get(GUIOptions.WORKPATH), Text.FILE + (c == 1 ? "" : Integer.valueOf(c)));
    }

    private EditorArea addTab() {
        final EditorArea edit = new EditorArea(this, this.newTabFile());
        edit.setFont(GUIConstants.mfont);
        BaseXBack tab = new BaseXBack(new BorderLayout(10, 0)).mode(GUIConstants.Fill.NONE);
        tab.add((Component)edit.label, "Center");
        AbstractButton close = this.tabButton("e_close", "e_close2");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorView.this.close(edit);
            }
        });
        tab.add((Component)close, "East");
        this.tabs.add((Component)edit, tab, this.tabs.getComponentCount() - 2);
        return edit;
    }

    private void addCreateTab() {
        AbstractButton add = this.tabButton("e_new", "e_new2");
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorView.this.refreshControls(EditorView.this.addTab(), true);
            }
        });
        this.tabs.add((Component)new BaseXBack(), add, 0);
        this.tabs.setEnabledAt(0, false);
    }

    private AbstractButton tabButton(String icon, String rollover) {
        AbstractButton b = BaseXButton.get(icon, null, false, this.gui);
        b.setBorder(new EmptyBorder(2, 0, 2, 0));
        b.setContentAreaFilled(false);
        b.setFocusable(false);
        b.setRolloverIcon(BaseXImages.icon(rollover));
        return b;
    }

    private boolean confirm(EditorArea edit) {
        Boolean ok;
        return !edit.modified || !edit.opened() && edit.getText().length == 0 || (ok = BaseXDialog.yesNoCancel(this.gui, Util.info(Text.CLOSE_FILE_X, edit.file.name()))) != null && (ok == false || this.save());
    }

    private EditorArea[] editors() {
        ArrayList<EditorArea> edits = new ArrayList<EditorArea>();
        for (Component c : this.tabs.getComponents()) {
            if (!(c instanceof EditorArea)) continue;
            edits.add((EditorArea)c);
        }
        return edits.toArray(new EditorArea[edits.size()]);
    }
}

