/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import java.awt.Window;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.gui.GUI;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewData;
import org.basex.gui.view.ViewMover;
import org.basex.gui.view.ViewPanel;
import org.basex.util.Array;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;

public final class ViewNotifier {
    private static final long LARGEDB = 200000000L;
    public static final int MAXHIST = 20;
    public int hist;
    final GUI gui;
    private final Nodes[] marked = new Nodes[20];
    private final Nodes[] cont = new Nodes[20];
    private final String[] queries = new String[20];
    private View[] view = new View[0];
    private int histsize;

    public ViewNotifier(GUI main) {
        this.gui = main;
    }

    void add(View v) {
        this.view = Array.add(this.view, v);
    }

    public void init() {
        Data data = this.initHistory(this.gui.context);
        if (data != null) {
            long size = data.meta.dbsize();
            boolean open = false;
            for (View v : this.view) {
                open |= v.visible() && v.db();
            }
            if (open && size > 200000000L && BaseXDialog.confirm(this.gui, Util.info(Text.H_LARGE_DB, Performance.format(size)))) {
                for (View v : this.view) {
                    if (!v.visible() || !v.db()) continue;
                    v.visible(false);
                }
            }
        } else {
            for (Window w : this.gui.getOwnedWindows()) {
                if (!w.isVisible() || !(w instanceof BaseXDialog)) continue;
                ((BaseXDialog)w).cancel();
            }
        }
        this.gui.context.focused = -1;
        for (View v : this.view) {
            v.refreshInit();
        }
        this.gui.layoutViews();
        this.gui.setTitle(data != null ? data.meta.name : null);
    }

    public void focus(int pre, View vw) {
        if (this.gui.context.focused == pre) {
            return;
        }
        this.gui.context.focused = pre;
        for (View v : this.view) {
            if (v == vw || !v.visible()) continue;
            v.refreshFocus();
        }
        if (pre != -1) {
            this.gui.status.setText(Token.string(ViewData.path(this.gui.context.data(), pre)));
        }
    }

    public void mark(Nodes mark, View vw) {
        Context ctx = this.gui.context;
        ctx.marked = mark;
        for (View v : this.view) {
            if (v == vw || !v.visible()) continue;
            v.refreshMark();
        }
        this.gui.filter.setEnabled(mark.size() != 0L);
        this.gui.refreshControls();
    }

    public void mark(int mode, View vw) {
        int f = this.gui.context.focused;
        if (f == -1) {
            return;
        }
        Context ctx = this.gui.context;
        Nodes nodes = ctx.marked;
        if (mode == 0) {
            nodes = new Nodes(f, ctx.data());
        } else if (mode == 1) {
            nodes.union(new int[]{f});
        } else {
            nodes.toggle(f);
        }
        this.mark(nodes, vw);
    }

    public void hist(boolean forward) {
        String query;
        Context ctx = this.gui.context;
        if (forward) {
            if (this.hist == this.histsize) {
                return;
            }
            query = this.queries[++this.hist];
        } else {
            if (this.hist == 0) {
                return;
            }
            this.marked[this.hist] = ctx.marked;
            query = this.queries[--this.hist];
        }
        ctx.set(this.cont[this.hist], this.marked[this.hist]);
        this.gui.input.setText(query);
        for (View v : this.view) {
            if (!v.visible()) continue;
            v.refreshContext(forward, false);
        }
        this.gui.refreshControls();
    }

    public void context(Nodes nodes, boolean quick, View vw) {
        Nodes cmp;
        Context ctx = this.gui.context;
        Nodes newn = nodes.checkRoot();
        Nodes empty = new Nodes(new int[0], ctx.data(), ctx.marked.ftpos);
        Nodes curr = quick ? ctx.current() : null;
        Nodes nodes2 = cmp = quick ? curr : ctx.marked;
        if (this.cont[this.hist] == null ? cmp != null : cmp == null || !this.cont[this.hist].sameAs(cmp)) {
            this.checkHist();
            if (quick) {
                this.queries[this.hist] = "";
                this.marked[this.hist] = new Nodes(ctx.data());
                this.cont[++this.hist] = curr;
            } else {
                String in;
                this.queries[this.hist] = in = this.gui.input.getText();
                this.marked[this.hist] = ctx.marked;
                this.cont[++this.hist] = newn;
                this.queries[this.hist] = in;
                this.marked[this.hist] = empty;
            }
            this.histsize = this.hist;
        }
        ctx.set(newn, empty);
        for (View v : this.view) {
            if (v == vw || !v.visible()) continue;
            v.refreshContext(true, quick);
        }
        this.gui.refreshControls();
    }

    public void update() {
        Data data = this.initHistory(this.gui.context);
        if (data == null) {
            return;
        }
        this.gui.context.marked = new Nodes(data);
        for (View v : this.view) {
            if (!v.visible()) continue;
            v.refreshUpdate();
        }
        this.gui.refreshControls();
    }

    public void layout() {
        for (View v : this.view) {
            v.refreshLayout();
            ViewPanel vp = (ViewPanel)v.getParent();
            ViewMover vm = (ViewMover)vp.getComponent(0);
            vm.refreshLayout();
        }
    }

    public String query(boolean back) {
        return back ? (this.hist > 0 ? (this.hist > 1 ? this.queries[this.hist - 2] : "") : null) : (this.hist < this.histsize ? this.queries[this.hist + 1] : null);
    }

    private void checkHist() {
        int hl = this.queries.length;
        if (this.hist + 1 == hl) {
            Array.move(this.queries, 1, 0, hl - 1);
            Array.move(this.cont, 1, 0, hl - 1);
            Array.move(this.marked, 1, 0, hl - 1);
            --this.hist;
        }
    }

    private Data initHistory(Context ctx) {
        for (int h = 0; h < this.histsize; ++h) {
            this.marked[h] = null;
            this.cont[h] = null;
            this.queries[h] = null;
        }
        this.hist = 0;
        this.histsize = 0;
        Data data = ctx.data();
        if (data != null) {
            this.marked[0] = new Nodes(data);
            this.queries[0] = "";
        }
        return data;
    }
}

