/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXSplitSep;

public final class BaseXSplit
extends BaseXBack
implements LayoutManager {
    private final boolean horiz;
    private double[] propSize;
    private double[] dragSize;
    private double dragPos;
    private double[] hiddenSize;
    private double[] cachedSize;

    public BaseXSplit(boolean horizontal) {
        this.layout(this);
        this.horiz = horizontal;
    }

    @Override
    public Component add(Component comp) {
        if (this.getComponentCount() != 0) {
            super.add(new BaseXSplitSep(this.horiz));
        }
        super.add(comp);
        this.propSize = null;
        return comp;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.propSize = null;
    }

    public void init(double[] vis, double[] hidden) {
        this.propSize = vis;
        this.hiddenSize = hidden;
    }

    public void visible(boolean show) {
        boolean s = true;
        if (this.propSize != null) {
            for (double d : this.propSize) {
                s &= d != 0.0;
            }
        }
        if (this.propSize == null || s ^ show) {
            if (show) {
                this.propSize = this.cachedSize;
            } else {
                this.cachedSize = this.propSize;
                this.propSize = this.hiddenSize;
            }
            this.revalidate();
        }
    }

    void startDrag(double p) {
        this.dragPos = p;
        this.dragSize = (double[])this.propSize.clone();
    }

    void drag(BaseXSplitSep sep, double p) {
        int i;
        Component[] m = this.getComponents();
        int r = this.propSize.length;
        int q = 0;
        for (int n = 0; n < r - 1; ++n) {
            if (m[(n << 1) + 1] != sep) continue;
            q = n + 1;
        }
        double v = (this.dragPos - p) / (double)(this.horiz ? this.getWidth() : this.getHeight());
        for (i = 0; i < q; ++i) {
            if (!(this.dragSize[i] - v / (double)q < 1.0E-4)) continue;
            return;
        }
        for (i = q; i < r; ++i) {
            if (!(this.dragSize[i] + v / (double)(r - q) < 1.0E-4)) continue;
            return;
        }
        for (i = 0; i < q; ++i) {
            this.propSize[i] = this.dragSize[i] - v / (double)q;
        }
        for (i = q; i < r; ++i) {
            this.propSize[i] = this.dragSize[i] + v / (double)(r - q);
        }
        this.revalidate();
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getSize();
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        int n;
        Component[] c = this.getComponents();
        int w = this.getWidth();
        int h = this.getHeight();
        int panels = c.length + 1 >> 1;
        if (this.propSize == null) {
            this.propSize = new double[panels];
            for (n = 0; n < c.length; ++n) {
                if ((n & 1) != 0) continue;
                this.propSize[n >> 1] = 1.0 / (double)panels;
            }
        }
        n = panels - 1;
        for (double d : this.propSize) {
            if (d != 0.0) continue;
            --n;
        }
        int sz = (this.horiz ? w : h) - n * 8;
        double posD = 0.0;
        boolean invisible = false;
        for (n = 0; n < c.length; ++n) {
            int size;
            if ((n & 1) == 0) {
                size = (int)(this.propSize[n >> 1] * (double)sz);
                invisible = size == 0;
            } else {
                size = invisible ? 0 : 8;
            }
            int pos = (int)posD;
            if (this.horiz) {
                c[n].setBounds(pos, 0, size, h);
            } else {
                c[n].setBounds(0, pos, w, size);
            }
            posD += (double)size;
        }
    }
}

