/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.parse;

import java.util.ArrayList;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.parse.CmdParser;
import org.basex.core.parse.PasswordReader;
import org.basex.core.parse.StringParser;
import org.basex.core.parse.XMLParser;
import org.basex.query.QueryException;
import org.basex.query.value.item.QNm;

public final class CommandParser {
    private final CmdParser parser;

    public CommandParser(String in, Context c) {
        this.parser = in.startsWith("<") ? new XMLParser(in, c) : new StringParser(in, c);
    }

    public CommandParser pwReader(PasswordReader pr) {
        this.parser.pwReader(pr);
        return this;
    }

    public Command parseSingle() throws QueryException {
        return this.parse(true, false)[0];
    }

    public Command[] parse() throws QueryException {
        return this.parse(false, false);
    }

    public Command[] suggest() throws QueryException {
        return this.parse(false, true);
    }

    private Command[] parse(boolean single, boolean suggest) throws QueryException {
        ArrayList<Command> cmds = new ArrayList<Command>();
        this.parser.parse(cmds, single, suggest);
        if (!single || cmds.size() == 1) {
            return cmds.toArray(new Command[cmds.size()]);
        }
        throw new QueryException(null, new QNm(), Text.SINGLE_CMD, new Object[0]);
    }
}

