/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.Execute;
import org.basex.core.cmd.XQuery;
import org.basex.io.IO;
import org.basex.util.Util;

public final class Run
extends Execute {
    private IO file;

    public Run(String fl) {
        super(fl);
    }

    @Override
    protected boolean init(Context ctx) {
        if (this.file == null) {
            this.file = IO.get(this.args[0]);
            if (!this.file.exists() || this.file.isDir()) {
                this.error = Util.info(Text.RES_NOT_FOUND_X, ctx.user.has(Perm.CREATE) ? this.file : this.args[0]);
            } else {
                try {
                    String input = this.file.string();
                    if (this.file.hasSuffix(".bxs")) {
                        return this.init(input, ctx);
                    }
                    this.list.add(new XQuery(input));
                }
                catch (IOException ex) {
                    this.error = Util.message(ex);
                }
            }
        }
        ctx.options.set(MainOptions.QUERYPATH, this.file.path());
        return this.error == null;
    }

    @Override
    protected void finish(Context ctx) {
        ctx.options.set(MainOptions.QUERYPATH, "");
    }
}

