/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.Locale;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.AGet;
import org.basex.util.options.Option;
import org.basex.util.options.Options;

public final class Get
extends AGet {
    public Get() {
        this((String)null);
    }

    public Get(Option<?> option) {
        this(option.name());
    }

    public Get(String key) {
        super(key);
    }

    @Override
    protected boolean run() throws IOException {
        if (this.args[0] == null) {
            if (this.context.user.has(Perm.ADMIN)) {
                this.out.println(Text.GLOBAL_OPTIONS + ":");
                for (Option<?> o : this.goptions) {
                    this.out.println(o.name() + ": " + this.goptions.get(o));
                }
            }
            this.out.println(Text.NL + Text.LOCAL_OPTIONS + ":");
            for (Option<?> o : this.options) {
                this.out.println(o.name() + ": " + this.options.get(o));
            }
        } else {
            String name = this.args[0].toUpperCase(Locale.ENGLISH);
            try {
                this.out.println(name + ": " + Get.get(name, this.context));
            }
            catch (BaseXException ex) {
                return this.error(ex.getMessage(), new Object[0]);
            }
        }
        return true;
    }

    public static String get(String name, Context ctx) throws BaseXException {
        Options opts = ctx.options;
        Option<?> opt = opts.option(name);
        if (opt == null && ctx.user.has(Perm.ADMIN)) {
            opts = ctx.globalopts;
            opt = opts.option(name);
        }
        if (opt == null) {
            throw new BaseXException(ctx.options.error(name), new Object[0]);
        }
        return opts.get(opt).toString();
    }
}

