/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.Text;
import org.basex.core.cmd.ABackup;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.io.IOFile;
import org.basex.util.list.StringList;

public class DropBackup
extends ABackup {
    public DropBackup(String name) {
        super(name);
    }

    @Override
    protected boolean run() {
        String name = this.args[0];
        if (!Databases.validName(name, true)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        StringList dbs = this.context.databases.listDBs(name);
        if (dbs.isEmpty()) {
            dbs.add(name);
        }
        for (String db : dbs) {
            for (String backup : this.context.databases.backups(db)) {
                DropBackup.drop(backup, this.context);
            }
        }
        return this.info(Text.BACKUP_DROPPED_X, name + '*' + ".zip");
    }

    public static boolean drop(String name, Context ctx) {
        return new IOFile(ctx.globalopts.dbpath(), name + ".zip").delete();
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.DROP) + " " + (Object)((Object)Commands.CmdDrop.BACKUP)).args();
    }
}

