/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.Date;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.LockResult;
import org.basex.core.Text;
import org.basex.core.cmd.ABackup;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.io.Zip;
import org.basex.util.DateTime;
import org.basex.util.list.StringList;

public final class CreateBackup
extends ABackup {
    public CreateBackup(String arg) {
        super(arg);
    }

    @Override
    protected boolean run() {
        String name = this.args[0];
        if (!Databases.validName(name, true)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        StringList dbs = this.context.databases.listDBs(name);
        if (dbs.isEmpty()) {
            return this.error(Text.DB_NOT_FOUND_X, name);
        }
        boolean ok = true;
        for (String db : dbs) {
            if (!this.goptions.dbpath(db).isDir()) continue;
            if (MetaData.file(this.context.globalopts.dbpath(db), "upd").exists()) {
                this.info(Text.DB_UPDATED_X, db);
                ok = false;
                continue;
            }
            try {
                CreateBackup.backup(db, this.context, this);
                this.info(Text.DB_BACKUP_X, db, this.perf);
            }
            catch (IOException ex) {
                this.info(Text.DB_NOT_BACKUP_X, db);
                ok = false;
            }
        }
        return ok;
    }

    public static void backup(String db, Context ctx, CreateBackup cmd) throws IOException {
        String backup = db + '-' + DateTime.format(new Date(), DateTime.DATETIME) + ".zip";
        IOFile zf = ctx.globalopts.dbpath(backup);
        Zip zip = new Zip(zf);
        if (cmd != null) {
            cmd.proc(zip);
        }
        IOFile dbpath = ctx.globalopts.dbpath(db);
        StringList files = dbpath.descendants();
        files.delete("upd.basex");
        zip.zip(dbpath, files);
    }

    @Override
    public void databases(LockResult lr) {
        super.databases(lr);
        this.databases(lr.read, 0);
    }

    @Override
    protected String tit() {
        return Text.BACKUP;
    }

    @Override
    public boolean supportsProg() {
        return true;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.CREATE) + " " + (Object)((Object)Commands.CmdCreate.BACKUP)).args();
    }
}

