/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.LinkedList;
import org.basex.core.Context;
import org.basex.core.GlobalOptions;
import org.basex.core.Locking;
import org.basex.core.Proc;
import org.basex.util.Util;
import org.basex.util.list.StringList;

final class ProcLocking
implements Locking {
    private final LinkedList<Object> queue = new LinkedList();
    private final Object mutex = new Object();
    private final Context ctx;
    private int readers;
    private boolean writer;

    ProcLocking(Context c) {
        this.ctx = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquire(Proc pr, StringList read, StringList write) {
        Object o = new Object();
        Object object = this.mutex;
        synchronized (object) {
            this.queue.add(o);
            int maxReaders = Math.max(this.ctx.globalopts.get(GlobalOptions.PARALLEL), 1);
            while (true) {
                if (!this.writer && o == this.queue.get(0)) {
                    if (pr.updating) {
                        if (this.readers == 0) {
                            this.writer = true;
                            break;
                        }
                    } else if (this.readers < maxReaders) {
                        ++this.readers;
                        break;
                    }
                }
                pr.checkStop();
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException ex) {
                    Util.stack(ex);
                }
            }
            this.queue.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Proc pr) {
        Object object = this.mutex;
        synchronized (object) {
            if (pr.updating) {
                this.writer = false;
            } else {
                --this.readers;
            }
            this.mutex.notifyAll();
        }
    }
}

