/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.IOStream;
import org.basex.io.in.NewlineInput;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Lang {
    private static final String SUFFIX = "lang";
    private static final HashMap<String, String> TEXTS = new HashMap();
    private static final HashMap<String, Boolean> CHECK = new HashMap();

    private Lang() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void read(String lang) {
        TEXTS.clear();
        CHECK.clear();
        String path = "/lang/" + lang + '.' + SUFFIX;
        InputStream is = Lang.class.getResourceAsStream(path);
        if (is == null) {
            Util.errln(path + " not found.", new Object[0]);
        } else {
            try {
                NewlineInput nli = new NewlineInput(is);
                try {
                    String line;
                    while ((line = nli.readLine()) != null) {
                        int i = line.indexOf(61);
                        if (i == -1 || line.startsWith("#")) continue;
                        String key = line.substring(0, i).trim();
                        String val = line.substring(i + 1).trim();
                        if ("langright".equals(key)) {
                            Prop.langright = "true".equals(val);
                            continue;
                        }
                        if (val.contains("\\n")) {
                            val = val.replaceAll("\\\\n", Prop.NL);
                        }
                        if (Prop.langkeys) {
                            val = '[' + key + ": " + val + ']';
                        }
                        if (TEXTS.put(key, val) != null) {
                            Util.errln("%.lang: '%' is declared twice", lang, key);
                        }
                        CHECK.put(key, true);
                    }
                }
                finally {
                    nli.close();
                }
            }
            catch (IOException ex) {
                Util.errln(ex, new Object[0]);
            }
        }
    }

    static synchronized String lang(String key) {
        if (key == null) {
            for (String s : CHECK.keySet()) {
                Util.errln("%.lang: '%' can be removed", Prop.language, s);
            }
            return null;
        }
        String val = TEXTS.get(key);
        if (val == null) {
            Util.errln("%.lang: '%' is missing", Prop.language, key);
            return '[' + key + ']';
        }
        CHECK.remove(key);
        return val;
    }

    static synchronized String lang(String key, Object ... e) {
        return Util.info(Lang.lang(key), e);
    }

    public static synchronized String[][] parse() {
        StringList langs = new StringList();
        StringList creds = new StringList();
        try {
            URL url = Lang.class.getResource("/lang");
            if ("jar".equals(url.getProtocol())) {
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                String pre = conn.getEntryName();
                JarFile jar = conn.getJarFile();
                Enumeration<JarEntry> je = jar.entries();
                while (je.hasMoreElements()) {
                    JarEntry entry = je.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(pre) || !name.endsWith(SUFFIX)) continue;
                    byte[] cont = new IOStream(jar.getInputStream(entry)).read();
                    langs.add(name.replaceAll(".*/|.lang", ""));
                    creds.add(Lang.credits(cont));
                }
            } else {
                for (IOFile f : IOFile.get(url.toString()).children()) {
                    langs.add(f.name().replaceAll(".lang", ""));
                    creds.add(Lang.credits(((IO)f).read()));
                }
            }
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
        }
        return new String[][]{langs.toArray(), creds.toArray()};
    }

    private static synchronized String credits(byte[] cont) {
        StringTokenizer st = new StringTokenizer(Token.string(cont), "\n");
        st.nextToken();
        return st.nextToken().replaceAll("# ", "");
    }

    public static void check() {
        IOFile[] files;
        Lang.read("English");
        StringBuilder sb = new StringBuilder();
        HashSet<String> set = new HashSet<String>();
        for (String s : TEXTS.keySet()) {
            set.add(s);
        }
        for (IOFile f : files = new IOFile("src/main/resources/lang").children()) {
            String lang = f.name().replace(".lang", "");
            if ("English".equals(lang)) continue;
            Lang.read(lang);
            for (String o : set.toArray(new String[set.size()])) {
                if (TEXTS.remove(o) != null) continue;
                sb.append("- ").append(o).append('\n');
            }
            if (sb.length() != 0) {
                Util.err("Missing in %.lang:\n%", lang, sb);
                sb.setLength(0);
            }
            for (String s : TEXTS.keySet()) {
                sb.append("- ").append(s).append('\n');
            }
            if (sb.length() == 0) continue;
            Util.err("Not defined in %.lang:\n%", lang, sb);
            sb.setLength(0);
        }
    }

    static {
        Lang.read(Prop.language);
    }
}

