/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.io.IOFile;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.server.ClientListener;
import org.basex.server.Sessions;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class Events
extends HashMap<String, Sessions> {
    private final IOFile file = new IOFile(Prop.HOME, ".basexevents");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Events() {
        if (!this.file.exists()) {
            return;
        }
        DataInput in = null;
        try {
            in = new DataInput(this.file);
            int s = in.readNum();
            for (int u = 0; u < s; ++u) {
                this.put(Token.string(in.readToken()), new Sessions());
            }
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized boolean create(String name) {
        boolean b;
        boolean bl = b = this.put(name, new Sessions()) == null;
        if (b) {
            this.write();
        }
        return b;
    }

    public synchronized boolean drop(String name) {
        boolean b;
        boolean bl = b = this.remove(name) != null;
        if (b) {
            this.write();
        }
        return b;
    }

    private void write() {
        try {
            DataOutput out = new DataOutput(this.file);
            out.writeNum(this.size());
            for (String name : this.keySet()) {
                out.writeToken(Token.token(name));
            }
            out.close();
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
    }

    public synchronized String info() {
        TokenBuilder tb = new TokenBuilder();
        tb.addExt(Text.EVENTS_X, this.size()).add(this.size() == 0 ? "." : ":");
        Object[] names = this.keySet().toArray(new String[this.size()]);
        Arrays.sort(names);
        for (Object n : names) {
            tb.add(Text.NL).add("- ").add((String)n);
        }
        return tb.toString();
    }

    public synchronized boolean notify(Context ctx, byte[] name, byte[] msg) {
        Sessions sess = (Sessions)this.get(Token.string(name));
        if (sess == null) {
            return false;
        }
        for (ClientListener srv : sess) {
            if (srv == ctx.listener) continue;
            try {
                srv.notify(name, msg);
            }
            catch (IOException ex) {
                sess.remove(srv);
            }
        }
        return true;
    }
}

