/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.basex.build.Builder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Store;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.IOStream;
import org.basex.io.in.TarEntry;
import org.basex.io.in.TarInputStream;
import org.basex.util.Prop;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class DirParser
extends Parser {
    private static final int SKIPLOG = 10;
    private final StringList skipped = new StringList();
    private final Pattern filter;
    private final String root;
    private final boolean archives;
    private final boolean skipCorrupt;
    private final boolean addRaw;
    private final boolean dtd;
    private final boolean rawParser;
    private IOFile rawPath;
    private IO lastSrc;
    private Parser parser;
    private int c;

    public DirParser(IO source, MainOptions options) {
        super(source, options);
        String parent = source.dirPath();
        this.root = parent.endsWith("/") ? parent : parent + '/';
        this.skipCorrupt = options.get(MainOptions.SKIPCORRUPT);
        this.archives = options.get(MainOptions.ADDARCHIVES);
        this.addRaw = options.get(MainOptions.ADDRAW);
        this.dtd = options.get(MainOptions.DTD);
        this.rawParser = options.get(MainOptions.PARSER) == MainOptions.MainParser.RAW;
        this.filter = !source.isDir() && !source.isArchive() ? null : Pattern.compile(IOFile.regex(options.get(MainOptions.CREATEFILTER)));
    }

    public DirParser(IO source, Context context, IOFile path) {
        this(source, context.options);
        if (path != null && (this.addRaw || this.rawParser)) {
            this.rawPath = new IOFile(path, "raw");
        }
    }

    @Override
    public void parse(Builder build) throws IOException {
        build.meta.filesize = 0L;
        build.meta.original = this.src.path();
        this.parse(build, this.src);
    }

    private void parse(Builder b, IO io) throws IOException {
        if (io instanceof IOFile && io.isDir()) {
            for (IOFile f : ((IOFile)io).children()) {
                this.parse(b, f);
            }
        } else if (this.archives && io.isArchive()) {
            String name = io.name().toLowerCase(Locale.ENGLISH);
            InputStream in = io.inputStream();
            if (name.endsWith(".tar") || name.endsWith(".tgz") || name.endsWith(".tar.gz")) {
                TarEntry ze;
                if (!name.endsWith(".tar")) {
                    in = new GZIPInputStream(in);
                }
                TarInputStream is = new TarInputStream(in);
                while ((ze = is.getNextEntry()) != null) {
                    if (ze.isDirectory()) continue;
                    this.src = new IOStream(is, ze.getName());
                    this.src.length(ze.getSize());
                    this.parseResource(b);
                }
                is.close();
            } else if (name.endsWith(".gz")) {
                GZIPInputStream is = new GZIPInputStream(in);
                this.src = new IOStream(is, io.name().replaceAll("\\..*", ".xml"));
                this.parseResource(b);
                is.close();
            } else {
                ZipEntry ze;
                ZipInputStream is = new ZipInputStream(in);
                while ((ze = is.getNextEntry()) != null) {
                    if (ze.isDirectory()) continue;
                    this.src = new IOStream(is, ze.getName());
                    this.src.length(ze.getSize());
                    this.parseResource(b);
                }
                is.close();
            }
        } else {
            this.src = io;
            this.parseResource(b);
        }
    }

    private void parseResource(Builder b) throws IOException {
        b.checkStop();
        long l = this.src.length();
        if (l != -1L) {
            b.meta.filesize += l;
        }
        String targ = this.target;
        String path = this.src.path();
        String name = this.src.name();
        if (path.endsWith('/' + name)) {
            if ((path = path.substring(0, path.length() - name.length())).startsWith(this.root)) {
                path = path.substring(this.root.length());
            }
            targ = (targ + path).replace("//", "/");
        }
        boolean exclude = false;
        if (this.filter != null) {
            String nm = Prop.CASE ? this.src.name() : this.src.name().toLowerCase(Locale.ENGLISH);
            boolean bl = exclude = !this.filter.matcher(nm).matches();
        }
        if (exclude) {
            if (this.addRaw && this.rawPath != null) {
                Store.store(this.src.inputSource(), new IOFile(this.rawPath, targ + name));
            }
        } else if (this.rawParser) {
            if (this.rawPath != null) {
                Store.store(this.src.inputSource(), new IOFile(this.rawPath, targ + name));
            }
        } else {
            boolean ok = true;
            IO in = this.src;
            if (this.skipCorrupt) {
                try {
                    if (!(this.src instanceof IOContent) && !this.dtd) {
                        in = new IOContent(this.src.read());
                        in.name(this.src.name());
                    }
                    this.parser = Parser.singleParser(in, this.options, targ);
                    MemBuilder.build("", this.parser);
                }
                catch (IOException ex) {
                    Util.debug(ex);
                    this.skipped.add(this.src.path());
                    ok = false;
                }
            }
            if (ok) {
                this.parser = Parser.singleParser(in, this.options, targ);
                this.parser.parse(b);
            }
            this.parser = null;
            if (Prop.debug && (++this.c & 0x3FF) == 0) {
                Util.err(";", new Object[0]);
            }
        }
    }

    @Override
    public String info() {
        TokenBuilder tb = new TokenBuilder();
        if (!this.skipped.isEmpty()) {
            tb.add(Text.SKIPPED).add(":").add(Text.NL);
            int s = this.skipped.size();
            for (int i = 0; i < s && i < 10; ++i) {
                tb.add("- ").add(this.skipped.get(i)).add(Text.NL);
            }
            if (s > 10) {
                tb.add("- ").addExt(Text.MORE_SKIPPED_X, s - 10).add(Text.NL);
            }
        }
        return tb.toString();
    }

    @Override
    public String det() {
        return this.parser != null ? this.parser.detail() : this.src.path();
    }

    @Override
    public double prog() {
        if (this.parser != null) {
            return this.parser.progress();
        }
        if (this.lastSrc == this.src) {
            return 1.0;
        }
        this.lastSrc = this.src;
        return Math.random();
    }

    @Override
    public void close() throws IOException {
        if (this.parser != null) {
            this.parser.close();
        }
    }
}

