/* REXX ----- RXCRC.CMD */

/* Register the external function */
call rxfuncadd "RxGetCrc", "rxcrcdll", "RxGetCrc"

/* Get the filename */
parse arg filename

/* Check parameter validity */
if filename = "" then
    call error( "Error: You must specify a filename!" )

/* Compute the crc */
crc = rxgetcrc( filename )

/* Check validity of filename */
if crc = "ERROR" then
    call error( "Error: Couldn't open" filename"." );

/* Output crc value */
say "CRC of" filename "is" crc"."

exit

/* Error handling routine */
error: procedure
    parse arg message
    say message
    exit
return
