/* nd4.cmd

   A ReXX version of ndc for the OS/2 port of BIND 8

   This program make the following assumptions
	emxkill.exe is in PATH
	named.exe is in PATH
	ndc.exe is in PATH
	named.conf is in ETC
	named.pid is in ETC

   Please change the three variables kill, named, and PIDFILE as needed
   if you move any of these files to other locations.

   emxkill.exe is written by Garey Smiley <garey@slink.com>
   ndc.cmd is written by Bjrn Mork <bjorn@mork.no>
   
   CMD file changed so it can work with Bind 8.2.4
   Bind 8.2.4 won't run correctly in detached mode. 
   With the util NoList you can hide the named.exe window completely. 
   http://hobbes.nmsu.edu/pub/os2/util/system/nolist2a.zip to download it.
   
   You can use ndc3.cmd to start/stop Bind and Nolist automatically hides the window
   Therefore it will be started bij ndc.exe
   changes by Peter Lindeman <peter@lindeman.org>

   VE hacked perfectly good copy of ndc2.cmd as ndc4.cmd <voytek@sbt.net.au>
   to add following options: master/slave/info & display STATUS as default
   we assume... ? 
*/

/* user defines below */
/* this will be obtained from user input... ? */

/* servers for this domain */
webserver='web.sbt.net.au'
webserverip='203.41.6.80'

/* define DNS servers for this domain */
/* put your own values here */

primaryip='203.41.6.2'
secondaryip='203.41.6.3'
primary='wombat.sbt.net.au'
secondary='redback.sbt.net.au'
mailx='echidna.sbt.net.au'
mailx2='postoffice.telstra.net'
admin='admin.sbt.net.au'
logfile='\logs\dns.log'

/* user defines end */

tab = '09'x
crlf = '0d0a'x
/* get named.conf location as say E:\MPTN\ETC\named.conf */
namedfile = value('ETC',,'OS2ENVIRONMENT')||'\named.conf'

kill  = '@emxkill'
named = '@ndc.exe -c 127.0.0.1/101 start -c '||value('ETC',,'OS2ENVIRONMENT')||'\named.conf 2>nul'

PIDFILE = value('ETC',,'OS2ENVIRONMENT')||'\named.pid'

/* parse upper arg command domain */
parse arg command domain
signal on halt
command=translate(command)
domain=STRIP(domain)

if (stream(PIDFILE,'c','query exist')\='') then do
	pid = strip(linein(PIDFILE))
	rc = stream(PIDFILE, 'c', 'close')
	do while (queued()>0)
		pull .				/* Empty the queue	*/
	end
	'@pstat /P:'||d2x(pid)||' 2>nul |find /i /c "named.exe"|rxqueue'
	pull tmp
	RUNNING=strip(tmp)
	if (RUNNING=0) then PS='named (pid 'pid'?) not running'
	else PS='named is running (pid 'pid')'
end
else do
	PS='named (no pid file) not running'
	RUNNING=0
end

if ((arg() = 0)|(strip(command) = '')) then signal USAGE

select
	when (command = 'START') then nop
	when (command = 'STOP') then nop
	when (command = 'RESTART') then nop
	when (command = 'MASTER') then nop
	when (command = 'SLAVE') then nop
	when (command = 'INFO') then nop
otherwise
	if (RUNNING=0) then do 
		say PS
		exit 1
	end
end  /* select */

call RxFuncAdd'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

select

	when (command = 'STATUS') then say PS
	when (command = 'DUMPDB')

		then do 
			kill '2' pid	/* SIGINT */
			say 'Dumping Database'
		end

	when (command = 'INFO')

		then do 
			say PS
			say 'Following will be used to create new domains'
			say
			say '	webserver:'tab webserver
			say '	webserver ip:'tab webserverip
			say '	primary ip:'tab primaryip
			say '	secondary ip:'tab secondaryip
			say '	primary:'tab primary
			say '	secondary:'tab secondary
			say '	mail exch:'tab mailx
			say '	mail exch 2:'tab mailx2
			say '	admin address:'tab admin
			say '	logfile:'tab logfile
			say '	named config:'tab namedfile

		end

	when (command = 'RELOAD')

		then do 
			kill '1' pid	/* SIGHUP */
			say 'Reloading Database'
		end

	when (command = 'STATS')

		then do 
			kill '4' pid	/* SIGILL */
			say 'Dumping Statistics'
		end

	when (command = 'TRACE')

		then do 
			kill '16' pid	/* SIGUSR1 */
			say 'Trace Level Incremented'
		end

	when (command = 'NOTRACE')

		then do 
			kill '17' pid	/* SIGUSR2 */
			say 'Tracing Cleared'
		end

	when (command = 'QUERYLOG')|(command = 'QRYLOG')

		then do 
			kill '20' pid	/* SIGWINCH */
			say 'Query Logging Toggled'
		end

	when (command = 'START')
    		then if (RUNNING=1) then
			say 'ndc: start: named (pid 'pid') already running'
		else do
			call SysFileDelete PIDFILE
			named
			say 'Name server started'
		end
	when (command = 'STOP')
		then if (RUNNING=0) then
			say 'ndc: stop: named not running'
		else do
			kill '15' pid	/* SIGTERM */
			
			call SysFileDelete PIDFILE
			say 'Name Server Stopped'
		end
	when (command = 'RESTART')
		then do
     			if (RUNNING=1) then do
				kill '15' pid	/* SIGTERM */
			end
			call SysFileDelete PIDFILE
			named
			
			say 'Name Server Restarted'
		end /* do */

/* ve */
	when command = 'MASTER'
		then do
if (domain='') then do
say '	You have NOT specified domain you wish to add'
say '	TRY: ndc4 'command' domain.name'
exit
			end
SAY 'Adding to 'namedfile 'entry for 'domain
/* gets directory file path (scans named.conf for directory statements */
if 0 \= SysFileSearch("DIRECTORY", namedfile, "statement") then do
   call beep 880, 200
   say "There is no directory statement in" named " SysFileSearch() error #"rc
   say
   "@pause"
   exit
end /* do */

/* discards invalid statements (comments) */
do i = 1 to statement.0

statement.i = TRANSLATE(statement.i,' ','"')
statement.i=  STRIP(statement.i)

   if "directory" = left(statement.i, 9) then do
      parse var statement.i . zonedir . . . 
      leave
   end /* do */
   end 

/* get \namedb location as in "directory=f:\dns\etc\namedb" */

/* do we need .master suffix ? zonefile='"domain||'.master'"' */

/* append lines to %etc%/named.conf  */
zonefile=domain||'.master'

call lineout namedfile, '// Added by ndc4.cmd on 'date() time()
call lineout namedfile,'' 
call lineout namedfile, 'zone' '"'domain'"' IN '{' 
call lineout namedfile,'   type 		master;'
call lineout namedfile,'   file'	 		'"'zonefile'"' ';' 
call lineout namedfile,'   allow-update 	{ none; };'
call lineout namedfile,'   allow-transfer 	{ any; };'
call lineout namedfile,'};'
call lineout namedfile,''
call lineout namedfile

/* if master DNS create zone file, skip for slave DNS */

/* create zone file on zone path */
zonefile=zonedir||'\'||zonefile

/* maybe we should use stem to allow for unknown # of items ? */
say 'Creating 'zonefile' for 'domain
/* we need to parse domain up to first '.' */

parse var domain dom'.'rest 
call lineout zonefile,'; BIND version named 8.2.4-REL Fri Jun  1 08:45:54 cet 2001',1
call lineout zonefile,'; BIND version tony@merlin.ansaro.com:/home/tony/prj/bind/bind824/src/bin/named '
call lineout zonefile,'; zone file for 'domain
call lineout zonefile,'; autogenerated with ndc4.cmd on 'date() time()
call lineout zonefile,';******************************** '
call lineout zonefile,';*  Start of Authority Records  * '
call lineout zonefile,';******************************** '
call lineout zonefile,';'
/* call lineout zonefile,'$ORIGIN 'rest||'.' */
call lineout zonefile,'@		IN	SOA     'primary'. 'admin'. ('
call lineout zonefile,'        		00000000 ; Serial number for this data (yymmdd##)'
call lineout zonefile,'				1800	; Refresh value for secondary name servers'
call lineout zonefile,'				600      ; Retry value for secondary name servers'
call lineout zonefile,'				604800   ; Expire value for secondary name servers'
call lineout zonefile,'				86400   ) ; Minimum TTL value'
call lineout zonefile,';'
call lineout zonefile,'		IN      NS      'primary'.'
call lineout zonefile,'		IN      NS      'secondary'.'
call lineout zonefile,';'
call lineout zonefile,'		IN      MX      10 'mailx'.'
call lineout zonefile,'		IN      MX      50 'mailx2'.'
call lineout zonefile,';'
call lineout zonefile,'localhost	IN      A       127.0.0.1'
call lineout zonefile,';'
call lineout zonefile,';********************************'
call lineout zonefile,';*  Domain Address Information  *'
call lineout zonefile,';********************************'
call lineout zonefile,';Addresses for the canonical names'
call lineout zonefile,'www             IN      CNAME'   webserver||'.'
call lineout zonefile,';'
call lineout zonefile

/* lets log all we done */

call lineout logfile, date() time() domain' added to 'namedfile
call lineout logfile

SAY 'new MASTER domain 'domain' added, we need to RESTART BIND'
SAY 'stand-by, restarting BIND: ndc4 restart'
'START /C ndc4 restart'

		end /* do */

	when (command = 'SLAVE')
		then do
if (domain='') then do
say '	You have NOT specified domain you wish to add'
say '	TRY: ndc4 slave domain.name'
exit
			end
SAY 'Adding to 'namedfile 'entry for 'domain' as a slave zone'
/* gets directory file path (scans named.conf for directory statements */
if 0 \= SysFileSearch("DIRECTORY", namedfile, "statement") then do
   call beep 880, 200
   say "There is no directory statement in" named " SysFileSearch() error #"rc
   say
   "@pause"
   exit
end /* do */

/* discards invalid statements (comments) */
do i = 1 to statement.0

statement.i = TRANSLATE(statement.i,' ','"')
statement.i=  STRIP(statement.i)

   if "directory" = left(statement.i, 9) then do
      parse var statement.i . zonedir . . . 
      leave
   end /* do */
   end 

/* get \namedb location as in "directory=f:\dns\etc\namedb" */
/* do we need .master suffix ? zonefile='"domain||'.master'"' */
/* append lines to %etc%/named.conf  */

zonefile=domain||'.slave'

call lineout namedfile, '// Added by ndc4.cmd on 'date() time()
call lineout namedfile,'' 
call lineout namedfile, 'zone' '"'domain'"' IN '{' 
call lineout namedfile,'   type'tab tab 'slave;'
call lineout namedfile,'   file'tab tab'"'zonefile'"' ';'
call lineout namedfile,'   masters {' 
call lineout namedfile,tab tab tab primaryip' ;'
call lineout namedfile,'   };'
call lineout namedfile,'};'
call lineout namedfile,''
call lineout namedfile

/* lets log all we done */

call lineout logfile, date() time() domain' added to 'namedfile
call lineout logfile

SAY 'new SLAVE domain 'domain' added, we need to RESTART BIND to effect ZONE TRANSFER'
SAY 'stand-by as BIND is re-started: ndc4 restart'

'START /C ndc4 restart'

		end /* do */

	otherwise
		signal USAGE

end	/* select */

return 0

USAGE:

 say PS
 say 'usage: ndc4 (status|dumpdb|reload|stats|trace|notrace|qrylog|start|stop|restart)'
 say '       ndc4 (master domain.name|slave domain.name) (info)' 
 say
 say 'add master/slave adds new domain from template and creates zone file'
 say

 exit 1

halt:
 say 'ndc aborted'
 exit 1
