/*
 * @(#)ComponentBeanInfo.java	1.9 96/12/18  
 * 
 * Copyright (c) 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion bdk_beta
 * 
 */

package sun.beans.infos;

import java.beans.*;

/**
 * BeanInfo descriptor for a standard AWT component.
 */

public class ComponentBeanInfo extends SimpleBeanInfo {
    private static final Class beanClass = java.awt.Component.class;

    public PropertyDescriptor[] getPropertyDescriptors() {
        try {
            PropertyDescriptor 
		      name = new PropertyDescriptor("name",       beanClass),
		background = new PropertyDescriptor("background", beanClass),
	        foreground = new PropertyDescriptor("foreground", beanClass),
		      font = new PropertyDescriptor("font",       beanClass),
		   enabled = new PropertyDescriptor("enabled",    beanClass),
		   visible = new PropertyDescriptor("visible",    beanClass);
	    enabled.setExpert(true);
            visible.setHidden(true);
      
            PropertyDescriptor[] rv = {name, background, foreground, font, enabled, visible};
            return rv;
        } catch (IntrospectionException e) {
            throw new Error(e.toString());
        }
    }
}


