/*
 * @(#)BoolEditor.java	1.15 96/12/16  
 * 
 * Copyright (c) 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion bdk_beta
 * 
 */

package sun.beans.editors;

/**
 * Property editor for a java builtin "boolean" type.
 */

import java.beans.*;

public class BoolEditor extends PropertyEditorSupport {


    public String getJavaInitializationString() {
	// This must return locale independnet Java.
	if (((Boolean)getValue()).booleanValue()) {
	    return ("true");
	} else {
	    return ("false");
	}
    }

    public String getAsText() {
	// Should localize this.
	if (((Boolean)getValue()).booleanValue()) {
	    return ("True");
	} else {
	    return ("False");
	}
    }

    public void setAsText(String text) throws java.lang.IllegalArgumentException {
	if (text.toLowerCase().equals("true")) {
	    setValue(Boolean.TRUE);
	} else if (text.toLowerCase().equals("false")) {
	    setValue(Boolean.FALSE);
	} else {
	    throw new java.lang.IllegalArgumentException(text);
	}
    }

    public String[] getTags() {
	String result[] = { "True", "False" };
	return result;
    }

}

