/*                                                                                            */
/* This program converts the trusers file (TCPIP 3.0) to tcpnbk.lst from TCP/IP 4.21 (AURORA) */
/*  Needs rexx_md5.zip from Daniel Hellerstein, located on hobbes.nmsu.edu/pub/os2/dev/rexx   */
/*                                                                                            */
/*             Written in 1999 from Marc Schneider (macke@macke.org)                          */
/*                                                                                            */

/* Global parameters begin           */
/* Change this to your favorites ... */
Parameter.comment        = ''
Parameter.uid            = ''
Parameter.gid            = ''
Parameter.shell          = 'telnetd.cmd'
Parameter.shell.parms    = ''
Parameter.shell.break    = 0
Parameter.homedir        = 'c:\'
Parameter.active         = 1
Parameter.log            = 'logall'
Parameter.idletimeout    = 900
Parameter.ftpd.active    = 1
Parameter.telnetd.active = 0
Parameter.rexecd.active  = 0
Parameter.nfsd.active    = 0
/*  Global parameters end            */


/*    No user servicable parts inside - from here !   */
/* Be sure to disconnect the powercord before editing */

if rxfuncquery('srx_sha')=1  then do
  rc = RXFuncAdd('SRXLoadFuncs', 'SRXFUNC', 'SRXLoadFuncs')
  if rc \= 1 then Signal DLL
  rc = SRXLoadFuncs()
end


parse arg infile outfile
if infile = '' | outfile = '' then Signal usage

if srx_sha('a') == '86F7E437 FAA5A7FC E15D1DDC B9EAEAEA 377667B8' then nop
else Signal wrong

call get_infile
say Line.0 'Users will be converted...'
call put_outfile
say Line.0 'Users are converted !'

exit 0


get_infile: Procedure Expose infile Line. Userid.
  a = 1
  if stream(infile,'C', 'QUERY EXISTS') \= '' then do until Lines(infile) = 0
     Line.a = STRIP(Linein(infile))
     if Line.a = '' then iterate
     parse value Line.a with hash':'Userid.a Userid.a.Password
     if TRANSLATE(hash) \= 'USER' then iterate
     else do 
        parse value linein(infile) with Userid.a.read
        parse value linein(infile) with Userid.a.write
     end /* do */
     a = a + 1
  end /* do */
  else Signal NO_IN
  Line.0 = a - 1
Return

put_outfile: procedure Expose Line. outfile Userid. Parameter.
  do a = 1 to Line.0

     if POS('^',Userid.a.read)  > 0 then Readmaster = 0
     else Readmaster = 1

     if WORD(userid.a.read,2) = '' then Noreaddir = 1
     else Noreaddir = 0

     if POS('^',Userid.a.write) > 0 then Writemaster = 0
     else Writemaster = 1

     if WORD(userid.a.write,2) = '' then Nowritedir = 1
     else Nowritedir = 0

     rc = lineout(outfile,'SRVRUSR=(')
     rc = lineout(outfile,'    USERID='Userid.a)
     rc = lineout(outfile,'    password='SPACE(srx_sha(Userid.a.Password),0))
     rc = lineout(outfile,'    comment='parameter.comment)
     rc = lineout(outfile,'    uid='parameter.uid)
     rc = lineout(outfile,'    gid='parameter.gid)
     if parameter.shell.break then break_shell = '/C '
     else break_shell = ' '
     rc = lineout(outfile,'    shell='break_shell||parameter.shell||parameter.shell.parms)
     if \Noreaddir then rc = lineout(outfile,'    homedir='WORD(Userid.a.read,2))
                   else rc = lineout(outfile,'    homedir='parameter.homedir)
     rc = lineout(outfile,'    FTPD=(')
     rc = lineout(outfile,'         active='Parameter.ftpd.active)
     if Noreaddir then rc = lineout(outfile,'         read=')
                  else rc = lineout(outfile,'         read='WORD(userid.a.read,2))
     rc = lineout(outfile,'         canread='Readmaster)
     if Nowritedir then rc = lineout(outfile,'         write=')
                   else rc = lineout(outfile,'         write='WORD(userid.a.write,2))
     rc = lineout(outfile,'         canwrite='Writemaster)
     rc = lineout(outfile,'         log='parameter.log)
     rc = lineout(outfile,'         idletimeout='parameter.idletimeout)
     rc = lineout(outfile,'    )')
     rc = lineout(outfile,'    TELNETD=(')
     rc = lineout(outfile,'         active='parameter.telnetd.active)
     rc = lineout(outfile,'    )')
     rc = lineout(outfile,'    rexecd=(')
     rc = lineout(outfile,'         active='parameter.rexecd.active)
     rc = lineout(outfile,'    )')
     rc = lineout(outfile,'    nfsd=(')
     rc = lineout(outfile,'         active='parameter.nfsd.active)
     rc = lineout(outfile,'    )')
     rc = lineout(outfile,')')
     rc = lineout(outfile)
  end /* do */

Return


usage:
  parse Source with . prg
  say ''
  say ' Usage:'
  say ''
  say ' 'FILESPEC('name',prg) 'input-file output-file'
  say ' '
  say ' Examples:'
  say ' 'FILESPEC('name',prg) '\\SRV01\C$\MPTN\ETC\TRUSERS \\SRV02\C$\MPTN\ETC\TCPNBK.LST'
  say ' 'FILESPEC('name',prg) 'C:\DOWNLOAD\TRUSERS C:\MPTN\ETC\TCPNBK.LST'
  say ''
exit -1

DLL:
  say ''
  say ' Missing SRXFUNC.DLL from Daniel Hellerstein, '
  say ' located on hobbes.nmsu.edu/pub/os2/dev/rexx/rexx_md5.zip'
  say " Maybe the DLL isn't in your LIBPATH."
  say ''
exit -1

Wrong:
  say ''
  say " Checksum isn't correct. Maybe you are using a different DLL ?"
  say ''
  say ' Should be: 86F7E437 FAA5A7FC E15D1DDC B9EAEAEA 377667B8'
  say ' Returned :' srx_sha('a')
  say ''
exit -1

NO_IN:
  say ''
  say ' Input file does not exists ('infile').'
Signal usage
