/*
    Animated Mouse Pointer
    Copyright (C) 1997 Christian Langanke

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

*/
/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using:
 *      SOM Emitter emitctm: 2.41
 */

#pragma info( nogen )

#ifndef SOM_Module_wpwcur_Source
#define SOM_Module_wpwcur_Source
#endif
#define WPWinCursor_Class_Source
#define M_WPWinCursor_Class_Source

#include "wpwcur.ih"

// own includes
#include "clstype.h"
#include "cursor.h"
#include "filetype.h"
#include "debug.h"
#include "info.h"
#include "macros.h"
#include "mptrptr.h"
#include "mptrppl.h"
#include "wpamptr.rch"
#include "mptrutil.h"
#include "mptrcnr.h"

// ids
#define ANIMATION_TIMER_ID   256
#define ANIMATION_TIMEOUT    150L

// prototypes
MRESULT EXPENTRY
wpwcur_NotebookPageProc( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 );

// ===========================================================================

SOM_Scope void SOMLINK
wcur_wpRefreshFileIcon( WPWinCursor* somSelf )
{
  APIRET   rc = NO_ERROR;
  BOOL     fSuccess = FALSE;
  ULONG    i;
  CHAR     szFilename[_MAX_PATH];
  ICONINFO iconinfo;
  PBYTE    pbIconData;
  HPOINTER hptr = NULLHANDLE;

  FDATE    fdateCurrentLastWrite;
  FTIME    ftimeCurrentLastWrite;
  ULONG    ulTimeout;
  HAB      hab = WinInitialize( 0 );
  BOOL     fIsFileModified;

  HPOINTER ahptr[ MAX_COUNT_POINTERS];
  ULONG    aulTimeout[ MAX_COUNT_POINTERS];
  ULONG    ulEntries = MAX_COUNT_POINTERS;
  ULONG    ulTableLen;

  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpRefreshFileIcon" );
  FUNCENTER();

  do
  {
    // Dateiname ermitteln
    _wpQueryFilename( somSelf, szFilename, TRUE );

    // Datei vergleichen
    fIsFileModified = IsFileModified( szFilename, _pfs3 );
    if( !fIsFileModified ) {
      break;
    }

    // fremdes Format laden
    memset( &iconinfo, 0, sizeof( iconinfo ));
    fSuccess = LoadFirstPointerFromCursorFile( szFilename, &hptr, &iconinfo );

    if( !fSuccess ) {
      break;
    }

    // Icon sichern
    if( hptr ) {
      // handle setzen
      // CHECK ME:
      // _wpSetIconHandle( somSelf, hptr );
      WPWinCursor_parent_WPDataFile_wpSetIcon( somSelf, hptr );

      // handle fr Zugriffsfunktionen sichern
      if( _hptr ) {
        WinDestroyPointer( _hptr );
        _hptr = 0;
      }

      // save hptr
      _hptr = hptr;
    }

    // jetzt Speicherbereich fr Struktur und Daten holen
    if( _piconinfo ) {
      _wpFreeMem( somSelf, _piconinfo );
    }
    _ulDataLen = iconinfo.cb + iconinfo.cbIconData;
    _piconinfo = _wpAllocMem( somSelf, _ulDataLen, &rc );
    if( _piconinfo == NULL ) {
      _ulDataLen = 0;
    } else {
      // Daten in Objektspeicher kopieren
      memset( _piconinfo, 0, _ulDataLen );
      pbIconData = (PBYTE)_piconinfo + iconinfo.cb;                     // Neue Adresse der Binrdaten ermitteln
      memcpy( _piconinfo, &iconinfo, iconinfo.cb );                     // Struktur kopieren
      memcpy( pbIconData, iconinfo.pIconData, iconinfo.cbIconData );    // Binrdaten anhngen
      _piconinfo->pIconData = pbIconData;                               // Adresse Binrdaten eintragen
    }

    // temporren Speicher freigeben
    if( iconinfo.pIconData ) {
      free( iconinfo.pIconData );
    }

    // jetzt Animation laden
    memset( ahptr,      0, sizeof( ahptr ));
    memset( aulTimeout, 0, sizeof( aulTimeout ));
    fSuccess = LoadFirstAnimationFromCursorFile( szFilename,
                                                 ahptr,
                                                 aulTimeout,
                                                 &ulEntries );
    if(( fSuccess ) && ( ulEntries > 1 )) {
      ulTableLen = ulEntries * sizeof( HPOINTER );
      _phpointerTable  = _wpAllocMem( somSelf, ulTableLen, &rc );
      _pulTimeoutTable = _wpAllocMem( somSelf, ulTableLen, &rc );
      if( _phpointerTable ) {
        memcpy( _phpointerTable, ahptr, ulTableLen );
        _ulAnimationCount = ulEntries;
      }
      if( _pulTimeoutTable ) {
        memcpy( _pulTimeoutTable, aulTimeout, ulTableLen );
      }
    }
  } while( FALSE );

  if( hab ) {
    WinTerminate( hab );
  }

  return;
}

// ===========================================================================

SOM_Scope ULONG SOMLINK
wcur_wpGetAnimationTimeframeValue( WPWinCursor* somSelf )
{
  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpGetAnimationTimeframeValue" );
  FUNCENTER();

  // ###
  return 0;
}

// ===========================================================================

SOM_Scope BOOL SOMLINK
wcur_wpSetAnimationTimeframeValue( WPWinCursor* somSelf, ULONG ulNewValue )
{
  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpSetAnimationTimeframeValue" );
  FUNCENTER();

  // ###
  return TRUE;
}

// ===========================================================================

SOM_Scope ULONG SOMLINK
wcur_InsertAnimationPage1( WPWinCursor* somSelf, HWND hwndDlg )
{
  PAGEINFO pi;
  CHAR     szTabName[ MAX_RES_STRLEN];
  HAB      hab          = WinQueryAnchorBlock( HWND_DESKTOP );
  HMODULE  hmodResource = _clsQueryResourceModuleHandle( _WPWinCursor );

  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_InsertAnimationPage" );
  FUNCENTER();

  LOADSTRING( IDTAB_NBANIMATION, szTabName );

  memset((PCH)&pi, 0, sizeof( PAGEINFO ));
  pi.cb                  = sizeof( PAGEINFO );
  pi.hwndPage            = NULLHANDLE;
  pi.usPageStyleFlags    = BKA_MAJOR;
  pi.usPageInsertFlags   = BKA_FIRST;
  pi.usSettingsFlags     = SETTINGS_PAGE_NUMBERS;
  pi.pfnwp               = wpwcur_NotebookPageProc;
  pi.resid               = hmodResource;
  pi.dlgid               = IsWARP3() ? IDDLG_DLG_ANIMATIONPAGE1_230 : IDDLG_DLG_ANIMATIONPAGE1;
  pi.pszName             = szTabName;
  pi.pCreateParams       = somSelf;
  pi.idDefaultHelpPanel  = IDPNL_USAGE_NBPAGE;
  pi.pszHelpLibraryName  = _clsQueryHelpLibrary( _WPWinCursor );

  return _wpInsertSettingsPage( somSelf, hwndDlg, &pi );
}

// ===========================================================================

SOM_Scope ULONG SOMLINK
wcur_InsertAnimationPage2( WPWinCursor* somSelf, HWND hwndDlg )
{
  PAGEINFO pi;
  CHAR     szTabName[ MAX_RES_STRLEN];
  HAB      hab          = WinQueryAnchorBlock( HWND_DESKTOP );
  HMODULE  hmodResource = _clsQueryResourceModuleHandle( _WPWinCursor );

  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_InsertAnimationPage2" );

  FUNCENTER();

  LOADSTRING( IDTAB_NBANIMATION, szTabName );

  memset((PCH)&pi, 0, sizeof( PAGEINFO ));
  pi.cb                  = sizeof( PAGEINFO );
  pi.hwndPage            = NULLHANDLE;
  pi.usPageStyleFlags    = BKA_MINOR;
  pi.usPageInsertFlags   = BKA_FIRST;
  pi.usSettingsFlags     = SETTINGS_PAGE_NUMBERS;
  pi.pfnwp               = wpwcur_NotebookPageProc;
  pi.resid               = hmodResource;
  pi.dlgid               = IsWARP3() ? IDDLG_DLG_ANIMATIONPAGE2_230 : IDDLG_DLG_ANIMATIONPAGE2;
  pi.pszName             = szTabName;
  pi.pCreateParams       = somSelf;
  pi.idDefaultHelpPanel  = IDPNL_USAGE_NBPAGE;
  pi.pszHelpLibraryName  = _clsQueryHelpLibrary( _WPWinCursor );

  return _wpInsertSettingsPage( somSelf, hwndDlg, &pi );
}

// ===========================================================================

SOM_Scope ULONG SOMLINK
wcur_InsertAnimationPage3( WPWinCursor* somSelf, HWND hwndDlg )
{
  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_InsertAnimationPage3" );

  /* Return statement to be customized: */
  return;
}

// ===========================================================================

SOM_Scope ULONG SOMLINK
wcur_wpAddFile1Page( WPWinCursor* somSelf, HWND hwndNotebook )
{
  ULONG ulResult;
  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpAddFile1Page" );

  _InsertAnimationPage2( somSelf, hwndNotebook );
  _InsertAnimationPage1( somSelf, hwndNotebook );

  ulResult = WPWinCursor_parent_WPDataFile_wpAddFile1Page( somSelf,
                                                           hwndNotebook );

  return ulResult;
}

// ===========================================================================

SOM_Scope ULONG SOMLINK
wcur_wpAddObjectGeneralPage( WPWinCursor* somSelf, HWND hwndNotebook )
{
  PAGEINFO pi;
  CHAR     szTabName[ MAX_RES_STRLEN];
  HAB      hab          = WinQueryAnchorBlock( HWND_DESKTOP );
  HMODULE  hmodResource = _clsQueryResourceModuleHandle( _WPWinCursor );

  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpAddObjectGeneralPage" );
  FUNCENTER();

  LOADSTRING( IsWARP3() ? IDTAB_NBGENERAL_230 : IDTAB_NBGENERAL, szTabName );

  memset((PCH)&pi, 0, sizeof( PAGEINFO ));
  pi.cb                  = sizeof( PAGEINFO );
  pi.hwndPage            = NULLHANDLE;
  pi.usPageStyleFlags    = BKA_MAJOR;
  pi.usPageInsertFlags   = BKA_FIRST;
  pi.usSettingsFlags     = SETTINGS_PAGE_NUMBERS;
  pi.pfnwp               = wpwcur_NotebookPageProc;
  pi.resid               = hmodResource;
  pi.dlgid               = IsWARP3() ? IDDLG_DLG_ICONPAGE_230 : IDDLG_DLG_ICONPAGE;
  pi.pszName             = szTabName;
  pi.pCreateParams       = somSelf;
  pi.idDefaultHelpPanel  = IDPNL_USAGE_NBPAGE;
  pi.pszHelpLibraryName  = _clsQueryHelpLibrary( _WPWinCursor );

  return _wpInsertSettingsPage( somSelf, hwndNotebook, &pi );
}

// ===========================================================================

SOM_Scope void SOMLINK
wcur_wpObjectReady( WPWinCursor* somSelf, ULONG ulCode, WPObject* refObject )
{
  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpObjectReady" );
  FUNCENTER();

  WPWinCursor_parent_WPDataFile_wpObjectReady( somSelf, ulCode,
                                               refObject );

  // fremdes Iconformat erstmalig laden
  _wpRefreshFileIcon( somSelf );
}

// ===========================================================================

SOM_Scope HPOINTER SOMLINK
wcur_wpQueryIcon( WPWinCursor* somSelf )
{
  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpQueryIcon" );
  FUNCENTER();

  // Icon erneuern
  _wpRefreshFileIcon( somSelf );

  if( _hptr ) {
    return _hptr;
  }

  return WPWinCursor_parent_WPDataFile_wpQueryIcon( somSelf );
}

// ===========================================================================

SOM_Scope ULONG SOMLINK
wcur_wpQueryIconData( WPWinCursor* somSelf, PICONINFO pIconInfo )
{
  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpQueryIconData" );
  FUNCENTER();

  // ACHTUNG: kein Refresh durchfhren, das passiert bereits durch wpQueryIcon

  // WPS ruft diese Funktion wie folgt auf
  // - 1. Call: pIconInfo = NULL, nur Rckgabe der Lnge
  // - 1. Call: pIconInfo = ptr,  Abfrage der Datan
  if( _ulDataLen ) {
    if( pIconInfo ) {
      memcpy( pIconInfo, _piconinfo, sizeof( ICONINFO ));
    }
    return _ulDataLen;
  }

  return WPWinCursor_parent_WPDataFile_wpQueryIconData( somSelf,
                                                        pIconInfo );
}

// ===========================================================================

SOM_Scope BOOL SOMLINK
wcur_wpSetIcon( WPWinCursor* somSelf, HPOINTER hptrNewIcon )
{
  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpSetIcon" );
  FUNCENTER();

  // don't set other icon than our own
  if( _hptr ) {
    hptrNewIcon = _hptr;
  }

  return WPWinCursor_parent_WPDataFile_wpSetIcon( somSelf,
                                                  hptrNewIcon );
}

// ===========================================================================

SOM_Scope BOOL SOMLINK
wcur_wpSetIconData( WPWinCursor* somSelf, PICONINFO pIconInfo )
{
  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpSetIconData" );
  FUNCENTER();

  // don't set icon data
  if( _ulDataLen ) {
    DEBUGMSG( "info: alarm: setIconFaked" NEWLINE, 0 );
    WinAlarm( HWND_DESKTOP, WA_ERROR );
    return TRUE;
  }

  return WPWinCursor_parent_WPDataFile_wpSetIconData( somSelf,
                                                      pIconInfo );
}

// ===========================================================================

SOM_Scope BOOL SOMLINK
wcur_wpModifyPopupMenu( WPWinCursor* somSelf, HWND hwndMenu, HWND hwndCnr, ULONG iPosition )
{
  BOOL   fSuccess = TRUE;
  APIRET rc = NO_ERROR;
  CHAR   szFilename[ _MAX_PATH];

  ULONG  ulSourceFileType;
  PSZ    pszFileExtension;
  ULONG  ulDeleteItem = 0;
  ULONG  ulPointerIndex;

  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpModifyPopupMenu" );
  FUNCENTER();

  // Submen an das Ende anhngen
  // - Position 0 ist am Ende des Mens
  // - Separator wird selbststndig eingefgt

  fSuccess =
    _wpInsertPopupMenuItems( somSelf, hwndMenu, 0,
                             _clsQueryResourceModuleHandle( _WPWinCursor ),
                             IDMEN_CONVERT_MENU, WPMENUID_PRIMARY );

  if( fSuccess ) {
    do
    {
      // Dateiname und Quelldateityp ermitteln
      _wpQueryFilename( somSelf, szFilename, TRUE );
      pszFileExtension = Filespec( szFilename, FILESPEC_EXTENSION );
      if( !pszFileExtension ) {
        break;
      }

      strupr( pszFileExtension );
      // DEBUGMSG( "--- file ext: %s" NEWLINE, pszFileExtension);
      if( !QueryResFileTypeFromExt( pszFileExtension, &ulSourceFileType )) {
        break;
      }

      // DEBUGMSG( "--- file type: %u" NEWLINE, ulSourceFileType);
      // Konvertierung auf eigenen Dateityp ausschlien
      switch( ulSourceFileType )
      {
        case RESFILETYPE_POINTER:
          ulDeleteItem =  IDMEN_CONVERT_POINTER;
          break;
        case RESFILETYPE_CURSOR:
          ulDeleteItem =  IDMEN_CONVERT_CURSOR;
          break;
        case RESFILETYPE_WINANIMATION:
          ulDeleteItem =  IDMEN_CONVERT_WINANIMATION;
          break;
        case RESFILETYPE_ANIMOUSE:
          ulDeleteItem =  IDMEN_CONVERT_ANIMOUSE;
          break;
      }
      if( ulDeleteItem ) {
        WinSendMsg( hwndMenu, MM_DELETEITEM, MPFROM2SHORT( ulDeleteItem, TRUE ), 0 );
      }

      //
      switch( ulSourceFileType )
      {
        case RESFILETYPE_POINTER:
        case RESFILETYPE_CURSOR:
        case RESFILETYPE_WINANIMATION:

          // DEBUGMSG( "--- check for pointername" NEWLINE, 0);
          if( !IsFilenameValid( szFilename,  FILENAME_CONTAINSPOINTERNAME, &ulPointerIndex )) {
            WinSendMsg( hwndMenu, MM_DELETEITEM, MPFROM2SHORT( IDMEN_CONVERT_ANIMOUSE, TRUE ), 0 );
          }
          break;
      }
    } while( FALSE );
  }

  return WPWinCursor_parent_WPDataFile_wpModifyPopupMenu( somSelf,
                                                          hwndMenu,
                                                          hwndCnr,
                                                          iPosition );
}

// ===========================================================================

SOM_Scope ULONG SOMLINK
wcur_wpFilterPopupMenu( WPWinCursor* somSelf, ULONG ulFlags, HWND hwndCnr, BOOL fMultiSelect )
{
  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpFilterPopupMenu" );

  ulFlags &= ~CTXT_PRINT;

  return WPWinCursor_parent_WPDataFile_wpFilterPopupMenu( somSelf,
                                                          ulFlags,
                                                          hwndCnr,
                                                          fMultiSelect );
}

// ===========================================================================

SOM_Scope BOOL SOMLINK
wcur_wpMenuItemSelected( WPWinCursor* somSelf, HWND hwndFrame, ULONG ulMenuId )
{
  ULONG  ulTargetFileType = 0;
  CHAR   szFilename[ _MAX_PATH];
  APIRET rc = NO_ERROR;

  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpMenuItemSelected" );
  FUNCENTER();

  switch( ulMenuId )
  {
    case IDMEN_CONVERT_POINTER:
      ulTargetFileType = RESFILETYPE_POINTER;
      break;
    case IDMEN_CONVERT_CURSOR:
      ulTargetFileType = RESFILETYPE_CURSOR;
      break;
    case IDMEN_CONVERT_WINANIMATION:
      ulTargetFileType = RESFILETYPE_WINANIMATION;
      break;
    case IDMEN_CONVERT_ANIMOUSE:
      ulTargetFileType = RESFILETYPE_ANIMOUSE;
      break;

    default:
      return WPWinCursor_parent_WPDataFile_wpMenuItemSelected( somSelf,
                                                               hwndFrame,
                                                               ulMenuId );
  }

  // Datei konvertiern
  _wpQueryFilename( somSelf, szFilename, TRUE );

  rc = ConvertFile( szFilename, ulTargetFileType );
  if( rc != NO_ERROR ) {
    DEBUGMSG( "error: alarm: could not convert file, rc=%u" NEWLINE, rc );
    WinAlarm( HWND_DESKTOP, WA_ERROR );
  }

  return TRUE;
}

// ===========================================================================

SOM_Scope BOOL SOMLINK
wcur_wpMenuItemHelpSelected( WPWinCursor* somSelf, ULONG MenuId )
{
  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpMenuItemHelpSelected" );
  FUNCENTER();

  // ###
  return WPWinCursor_parent_WPDataFile_wpMenuItemHelpSelected( somSelf,
                                                               MenuId );
}

// ===========================================================================

SOM_Scope void SOMLINK
wcur_wpInitData( WPWinCursor* somSelf )
{
  APIRET rc;
  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpInitData" );
  FUNCENTER();

  WPWinCursor_parent_WPDataFile_wpInitData( somSelf );

  do
  {
    // Variablen initialisieren
    _piconinfo = NULL;
    _hptr = NULLHANDLE;
    _ulDataLen = 0;
    _pfs3 = _wpAllocMem( somSelf, sizeof( FILESTATUS3 ), &rc );
    if( _pfs3 ) {
      memset( _pfs3, 0, sizeof( FILESTATUS3 ));
    }

    _phpointerTable   = NULL;
    _pulTimeoutTable  = NULL;
    _ulAnimationCount = 0;
  } while( FALSE );     // end do
}

// ===========================================================================

SOM_Scope void SOMLINK
wcur_wpUnInitData( WPWinCursor* somSelf )
{
  ULONG i;
  WPWinCursorData* somThis = WPWinCursorGetData( somSelf );

  WPWinCursorMethodDebug( "WPWinCursor", "wcur_wpUnInitData" );
  FUNCENTER();

  WPWinCursor_parent_WPDataFile_wpUnInitData( somSelf ); // ###

  // Speicher freigeben
  if( _piconinfo ) {
    _wpFreeMem( somSelf, _piconinfo );
  }
  if( _pfs3 ) {
    _wpFreeMem( somSelf, _pfs3 );
  }
  if( _hptr ) {
    WinDestroyPointer( _hptr );
  }

  for( i = 0; i < _ulAnimationCount; i++ )
  {
    WinDestroyPointer( *( _phpointerTable + i ));
  }

  if( _phpointerTable ) {
    _wpFreeMem( somSelf, _phpointerTable );
  }
  if( _pulTimeoutTable ) {
    _wpFreeMem( somSelf, _pulTimeoutTable );
  }

  WPWinCursor_parent_WPDataFile_wpUnInitData( somSelf );
}

// ===========================================================================

SOM_Scope HMODULE SOMLINK
wcur_MclsQueryResourceModuleHandle( M_WPWinCursor* somSelf )
{
  M_WPWinCursorData* somThis = M_WPWinCursorGetData( somSelf );

  M_WPWinCursorMethodDebug( "M_WPWinCursor", "wcur_MclsQueryResourceModuleHandle" );
  FUNCENTER();

  return _hmodResource;
}

// ===========================================================================

SOM_Scope PSZ SOMLINK
wcur_MclsQueryHelpLibrary( M_WPWinCursor* somSelf )
{
  M_WPWinCursorData* somThis = M_WPWinCursorGetData( somSelf );

  M_WPWinCursorMethodDebug( "M_WPWinCursor", "wcur_MclsQueryHelpLibrary" );
  FUNCENTER();

  return _szHelpLibrary;
}

SOM_Scope ULONG SOMLINK
wcur_MwpclsQueryStyle( M_WPWinCursor* somSelf )
{
  M_WPWinCursorData* somThis = M_WPWinCursorGetData( somSelf );

  M_WPWinCursorMethodDebug( "M_WPWinCursor", "wcur_MwpclsQueryStyle" );

  return M_WPWinCursor_parent_M_WPDataFile_wpclsQueryStyle( somSelf ) & CLSSTYLE_NEVERTEMPLATE;
}

// ===========================================================================

SOM_Scope PSZ SOMLINK
wcur_MwpclsQueryInstanceFilter( M_WPWinCursor* somSelf )
{
  /* M_WPWinCursorData *somThis = M_WPWinCursorGetData(somSelf); */
  M_WPWinCursorMethodDebug( "M_WPWinCursor", "wcur_MwpclsQueryInstanceFilter" );
  FUNCENTER();

  return FILEFILTER_WINCURSOR;
}

// ===========================================================================

SOM_Scope PSZ SOMLINK
wcur_MwpclsQueryInstanceType( M_WPWinCursor* somSelf )
{
  /* M_WPWinCursorData *somThis = M_WPWinCursorGetData(somSelf); */
  M_WPWinCursorMethodDebug( "M_WPWinCursor", "wcur_MwpclsQueryInstanceType" );
  FUNCENTER();

  return FILETYPE_WINCURSOR;
}

// ===========================================================================

SOM_Scope PSZ SOMLINK
wcur_MwpclsQueryTitle( M_WPWinCursor* somSelf )
{
  /* M_WPWinCursorData *somThis = M_WPWinCursorGetData(somSelf); */
  M_WPWinCursorMethodDebug( "M_WPWinCursor", "wcur_MwpclsQueryTitle" );
  FUNCENTER();

  return FILETYPE_WINCURSOR;
}

// ===========================================================================

SOM_Scope void SOMLINK
wcur_MwpclsInitData( M_WPWinCursor* somSelf )
{
  APIRET rc;

  M_WPWinCursorData* somThis = M_WPWinCursorGetData( somSelf );

  M_WPWinCursorMethodDebug( "M_WPWinCursor", "wcur_MwpclsInitData" );
  FUNCENTER();

  M_WPWinCursor_parent_M_WPDataFile_wpclsInitData( somSelf );

  // Load res module
  rc = LoadResourceLib( &_hmodResource );

  // reload class lib, so that it is available for static links
  rc = ReloadClassLib( &_hmodClassLib );

  // retrieve help library name
  rc = GetHelpLibName( _szHelpLibrary,  sizeof( _szHelpLibrary ));
}

// ===========================================================================

SOM_Scope void SOMLINK
wcur_MwpclsUnInitData( M_WPWinCursor* somSelf )
{
  APIRET rc;

  M_WPWinCursorData* somThis = M_WPWinCursorGetData( somSelf );

  M_WPWinCursorMethodDebug( "M_WPWinCursor", "wcur_MwpclsUnInitData" );
  FUNCENTER();

  // Unload resource DLL
  if( _hmodResource ) {
    rc = DosFreeModule( _hmodResource );
    _hmodResource = NULLHANDLE;
  }

  if( _hmodClassLib ) {
    rc = DosFreeModule( _hmodClassLib );
    _hmodClassLib = NULLHANDLE;
  }

  M_WPWinCursor_parent_M_WPDataFile_wpclsUnInitData( somSelf );
}

// =====================================================================================

// Routine nur einmal codieren !

typedef struct _WPSWINDOWDATA
{
  HMODULE hmodResource;
  SOMAny* somSelf;
  ULONG   ulAnimationTimerId;
  ULONG   ulPtrIndex;
} WPSWINDOWDATA, *PWPSWINDOWDATA;

// =====================================================================================

MRESULT EXPENTRY
wpwcur_NotebookPageProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  PWPSWINDOWDATA   pwd = WinQueryWindowPtr( hwnd, QWL_USER );
  SOMAny* somSelf;
  WPWinCursorData* somThis;
  APIRET rc = NO_ERROR;
  BOOL   fSuccess = FALSE;
  USHORT usPageId = WinQueryWindowUShort( hwnd, QWS_ID );
  HAB    hab = WinQueryAnchorBlock( hwnd );

  if( pwd ) {
    // Zugriff auf Klassenvariablen immer ermglichen
    somSelf = pwd->somSelf;
    somThis = WPWinCursorGetData( somSelf );
  }

  switch( msg ) {
    case WM_INITDLG:
    {
      PFNWP pfnwpOriginal;

      // store windowdata
      pwd = malloc( sizeof( WPSWINDOWDATA ));
      memset( pwd, 0, sizeof( WPSWINDOWDATA ));
      pwd->somSelf = (SOMAny*)mp2;
      WinSetWindowPtr( hwnd, QWL_USER, pwd );
      somSelf = pwd->somSelf;
      somThis = WPWinCursorGetData( somSelf );

      // Resource Module handle speichern
      pwd->hmodResource = _clsQueryResourceModuleHandle( _WPWinCursor );

      if( usPageId == IDDLG_DLG_ICONPAGE ) {
        HWND hwndIcon = WinWindowFromID( hwnd, IDDLG_IC_CONTENTS );
        HWND hwndGB   = WinWindowFromID( hwnd, IDDLG_GB_CONTENTS );
        SWP  swpGB;

        // fr icon page den Stil extra fr UNDO sichern
        _ulLastStyle = _wpQueryStyle( somSelf );

        // static text fr ICON  auf SS_ICON ndern
        WinSetWindowULong( hwndIcon,
                           QWL_STYLE,
                           WinQueryWindowULong( hwndIcon,
                                                QWL_STYLE ) | SS_ICON );

        // Window subclassen fr sauberes redraw
        WinSubclassWindow( hwndIcon, SubclassStaticWindowProc );

        // ICON innerhalb der Groupbox positionieren
        if( WinQueryWindowPos( hwndGB, &swpGB )) {
          WinSetWindowPos( hwndIcon, HWND_TOP,
                           swpGB.x + (( swpGB.cx - 32 ) / 2 ),
                           swpGB.y + (( swpGB.cy - 32 ) / 2 ),
                           32, 32,
                           SWP_MOVE | SWP_SIZE );
        }

        // ggfs. Animation starten
        if( _ulAnimationCount > 1 ) {
          WinSendMsg( hwnd, WM_TIMER, MPFROMLONG( ANIMATION_TIMER_ID ), 0 );
          pwd->ulAnimationTimerId = WinStartTimer( hab, hwnd, ANIMATION_TIMER_ID, ANIMATION_TIMEOUT );  // timeout value
        }
      }

      // Controls der Seite initialisieren
      WinSendMsg( hwnd, WM_COMMAND, MPFROM2SHORT( IDDLG_PB_UNDO, 0 ), 0L );
      break; // case WM_INITDLG:
    }

    case WM_TIMER:
    {
      ULONG    ulTimerId = SHORT1FROMMP( mp1 );
      HWND     hwndIcon     = WinWindowFromID( hwnd, IDDLG_IC_CONTENTS );
      HPOINTER hptr;
      ULONG    ulTimeout;

      if(( ulTimerId == ANIMATION_TIMER_ID ) && ( WinIsWindowVisible( hwndIcon ))) {
        // stop the timer
        WinStopTimer( hab, hwnd, ANIMATION_TIMER_ID );

        // set new handle
        hptr = *( _phpointerTable + pwd->ulPtrIndex );
        if( hptr ) {
          WinSendMsg( hwndIcon, SM_SETHANDLE, MPFROMLONG( hptr ), 0 );
          //          WinShowWindow( hwndIcon, FALSE);
          //          WinShowWindow( hwndIcon, TRUE);
        }

        // preselect next icon
        pwd->ulPtrIndex++;
        if( pwd->ulPtrIndex >= _ulAnimationCount ) {
          pwd->ulPtrIndex = 0;
        }

        // restart the timer
        ulTimeout = *( _pulTimeoutTable + pwd->ulPtrIndex );
        if( !ulTimeout ) {
          ulTimeout = ANIMATION_TIMEOUT;
        }
        //       DEBUGMSG("--- index: %u timeout: %u" NEWLINE, pwd->ulPtrIndex _c_ ulTimeout);
        pwd->ulAnimationTimerId = WinStartTimer( hab, hwnd, ANIMATION_TIMER_ID, ulTimeout );
      }
      break; // case WM_TIMER:
    }

    case WM_CONTROL:
      switch( usPageId ) {
        case IDDLG_DLG_ICONPAGE:
        {
          switch( SHORT1FROMMP( mp1 ))
          {
            ULONG ulStyle;
            BOOL  fCheck;

            case IDDLG_CB_TEMPLATE:
            {
              // query style
              ulStyle = _wpQueryStyle( somSelf );
              fCheck = DLGQUERYCHECK( hwnd, IDDLG_CB_TEMPLATE );
              if( fCheck ) {
                ulStyle |= OBJSTYLE_TEMPLATE;
              } else {
                ulStyle &= ~OBJSTYLE_TEMPLATE;
              }
              _wpSetStyle( somSelf, ulStyle );
              break;  // case IDDLG_CB_TEMPLATE:
            }

            case IDDLG_CB_LOCKPOS:
            {
              // query style
              ulStyle = _wpQueryStyle( somSelf );
              fCheck = DLGQUERYCHECK( hwnd, IDDLG_CB_LOCKPOS );
              if( fCheck ) {
                ulStyle |= OBJSTYLE_LOCKEDINPLACE;
              } else {
                ulStyle &= ~OBJSTYLE_LOCKEDINPLACE;
              }
              _wpSetStyle( somSelf, ulStyle );
              break;  // case IDDLG_CB_LOCKPOS:
            }
          }
          break;  // case IDDLG_DLG_ICONPAGE:
        }
      }
      break; // case WM_CONTROL:


    case WM_COMMAND:
      switch( SHORT1FROMMP( mp1 )) {
        case IDDLG_PB_UNDO:
          switch( usPageId ) {
            case IDDLG_DLG_ANIMATIONPAGE1:
            {
              CHAR  szFilename[_MAX_PATH];
              ULONG ulSourceInfoLen = 0;
              PSOURCEINFO psourceinfo = NULL;

              do
              {
                // Dateiname ermitteln
                _wpQueryFilename( somSelf, szFilename, TRUE );

                // Gre ermitteln
                QueryCursorFileDetails( szFilename, FI_SOURCEINFO, NULL, 0, &ulSourceInfoLen );
                // DEBUGMSG(" --- ulSourceInfoLen=%u" NEWLINE, ulSourceInfoLen);
                if( !ulSourceInfoLen ) {
                  break;
                }

                if(( psourceinfo = malloc( ulSourceInfoLen )) == NULL ) {
                  rc = ERROR_NOT_ENOUGH_MEMORY;
                  break;
                }

                // sourceinfo holen und in die Eingabefelder bringen
                rc = QueryCursorFileDetails( szFilename, FI_SOURCEINFO, psourceinfo, ulSourceInfoLen, &ulSourceInfoLen );
                // DEBUGMSG(" --- query sourceinfo rc=%u" NEWLINE, rc);
                DLGSETSTRING( hwnd, IDDLG_EF_INFONAME,   psourceinfo->pszInfoName );
                DLGSETSTRING( hwnd, IDDLG_EF_INFOARTIST, psourceinfo->pszInfoArtist );
                // mark filter fields as unchanged
                DLGQUERYCHANGED( hwnd, IDDLG_EF_INFONAME );
                DLGQUERYCHANGED( hwnd, IDDLG_EF_INFOARTIST );
              }  while( FALSE );

              // report error
              if( rc != NO_ERROR ) {
                DEBUGMSG( "error: alarm: could not query source info, rc=%u" NEWLINE, rc );
                WinAlarm( HWND_DESKTOP, WA_ERROR );
              }
              if( psourceinfo ) {
                free( psourceinfo );
              }
              break;  // case IDDLG_DLG_ANIMATIONPAGE1:
            }

            case IDDLG_DLG_ICONPAGE:
            {
              ULONG ulStyle;
              // set title
              DLGSETSTRING( hwnd, IDDLG_ME_TITLE, _wpQueryTitle( somSelf ));

              // mark title field as unchanged
              DLGQUERYCHANGED( hwnd, IDDLG_ME_TITLE );

              // query style and undo !
              ulStyle = _ulLastStyle;
              DLGSETCHECK( hwnd, IDDLG_CB_TEMPLATE, (( ulStyle & OBJSTYLE_TEMPLATE )      != 0 ));
              DLGSETCHECK( hwnd, IDDLG_CB_LOCKPOS,  (( ulStyle & OBJSTYLE_LOCKEDINPLACE ) != 0 ));
              _wpSetStyle( somSelf, _ulLastStyle );

              // set bitmap for icon, if not animated
              if( !pwd->ulAnimationTimerId ) {
                WinSendDlgItemMsg( hwnd, IDDLG_IC_CONTENTS, SM_SETHANDLE, MPFROMLONG( _hptr ), 0 );
              }
              break;  // case IDDLG_DLG_ICONPAGE:
            }
          }
          break;

        case IDDLG_PB_DEFAULT:
          switch( usPageId ) {
            case IDDLG_DLG_ICONPAGE:
            {
              ULONG ulStyle;
              // set title
              DLGSETSTRING( hwnd, IDDLG_ME_TITLE, _wpclsQueryTitle( _WPWinCursor ));

              // mark title field as unchanged
              DLGQUERYCHANGED( hwnd, IDDLG_ME_TITLE );

              // query style
              ulStyle = _wpclsQueryStyle( _WPWinCursor );
              _wpSetStyle( somSelf, ulStyle );
              DLGSETCHECK( hwnd, IDDLG_CB_TEMPLATE, ( ulStyle & OBJSTYLE_TEMPLATE ));
              DLGSETCHECK( hwnd, IDDLG_CB_LOCKPOS,  ( ulStyle & OBJSTYLE_LOCKEDINPLACE ));
              break;  // case IDDLG_DLG_ICONPAGE:
            }
          }
          break;
      }
      return (MRESULT)TRUE;

    case WM_DESTROY:
    {
      switch( usPageId ) {
        case IDDLG_DLG_ANIMATIONPAGE1:
        {
          CHAR szFilename[ _MAX_PATH];
          SOURCEINFO sourceinfo;
          CHAR szInfoName[ _MAX_PATH];
          CHAR szInfoArtist[ _MAX_PATH];

          BOOL fNameChanged   = DLGQUERYCHANGED( hwnd, IDDLG_EF_INFONAME );
          BOOL fArtistChanged = DLGQUERYCHANGED( hwnd, IDDLG_EF_INFOARTIST );

          if(( fNameChanged ) || ( fArtistChanged )) {
            CHAR szInfoName[ _MAX_PATH];
            CHAR szInfoArtist[ _MAX_PATH];

            // initialisieren
            memset( &sourceinfo, 0, sizeof( SOURCEINFO ));

            // Dateiname ermitteln
            _wpQueryFilename( somSelf, szFilename, TRUE );

            if( fNameChanged ) {
              DLGQUERYSTRING( hwnd, IDDLG_EF_INFONAME, szInfoName );
              sourceinfo.pszInfoName = szInfoName;
            }

            if( fArtistChanged ) {
              DLGQUERYSTRING( hwnd, IDDLG_EF_INFOARTIST, szInfoArtist );
              sourceinfo.pszInfoArtist = szInfoArtist;
            }

            // Attribute setzen
            rc = SetCursorFileInfo( szFilename, &sourceinfo );
            if( rc != NO_ERROR ) {
              DEBUGMSG( "error: alarm: could not change source info, rc=%u" NEWLINE, rc );
              WinAlarm( HWND_DESKTOP, WA_ERROR );
            }
          }
          break;  // case IDDLG_DLG_ANIMATIONPAGE1:
        }

        case IDDLG_DLG_ICONPAGE:
        {
          // stop timer
          if( pwd->ulAnimationTimerId ) {
            WinStopTimer( hab, hwnd, ANIMATION_TIMER_ID );
          }

          // save title
          if( MLEQUERYCHANGED( hwnd, IDDLG_ME_TITLE )) {
            CHAR szTitle[ _MAX_PATH + 32];
            BOOL fSuccess;

            DLGQUERYSTRING( hwnd, IDDLG_ME_TITLE, szTitle );
            fSuccess = _wpSetTitle( somSelf, szTitle );
          }

          // set handle to NULL, so that our handle is not destroyed
          WinSendDlgItemMsg( hwnd, IDDLG_IC_CONTENTS, SM_SETHANDLE, 0, 0 );
          break;  // case IDDLG_DLG_ICONPAGE:
        }
      }
    }
    break; // case WM_DESTROY:
  }

  return WinDefDlgProc( hwnd, msg, mp1, mp2 );
}

#pragma info( nouse )

