/**
	  Album Cover Grabber - Grabs album covers automatically off the internet
	  Copyright (C) 2002  Kevin M Schmidt

	  This program is free software; you can redistribute it and/or modify
	  it under the terms of the GNU General Public License as published by
	  the Free Software Foundation; either version 2 of the License, or
	  (at your option) any later version.

	  This program is distributed in the hope that it will be useful,
	  but WITHOUT ANY WARRANTY; without even the implied warranty of
	  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	  GNU General Public License for more details.

	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber;

/**
 * Singleton class that knows when to exit the program.
 * Basically once all the Mgr classes have reported that
 * they are finished, then exit.
 */
public class ExitProgram
{
	private static boolean AlbumGrabberFinished = false;
	private static boolean ImageChooserMgrFinished = true;

	public static void setAlbumGrabberFinished(boolean done)
	{
		AlbumGrabberFinished = done;
	}

	public static void setImageChooserMgrFinished(boolean done)
	{
		ImageChooserMgrFinished = done;
	}

	public static boolean isFinished()
	{
		//Check that all the proper classes have finished
		if (AlbumGrabberFinished &&
			 ImageChooserMgrFinished)
		{
			Report.getInstance().setEndTime(System.currentTimeMillis());
			Report.getInstance().report();
			System.exit(0);

			return true;
		}

		return false;
	}
}
