/**
	  Album Cover Grabber - Grabs album covers automatically off the internet
	  Copyright (C) 2002  Kevin M Schmidt

	  This program is free software; you can redistribute it and/or modify
	  it under the terms of the GNU General Public License as published by
	  the Free Software Foundation; either version 2 of the License, or
	  (at your option) any later version.

	  This program is distributed in the hope that it will be useful,
	  but WITHOUT ANY WARRANTY; without even the implied warranty of
	  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	  GNU General Public License for more details.

	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber;

import java.util.*;

/**
 * Singleton Cache class for performace enhancements
 */
public class Cache
{
	private static Cache instance = null;
	private Map artistSearchResults = new HashMap();

	/**
	 * Singleton get method
	 */
	public synchronized static Cache getInstance()
	{
		if (instance == null)
		{
			instance = new Cache();
		}

		return instance;
	}

	/**
	 * Creates a new Cache object.
	 */
	private Cache()
	{
	}

	/**
	 * Add an artist page to the cache
	 */
	public void addArtistSearchResult(String artistName, String html)
	{
		//Never let it get too big
		if (artistSearchResults.size() > 10)
		{
			artistSearchResults.clear();
		}

		artistSearchResults.put(artistName, html);
	}

	/**
	 * Get an artist page from the cache
	 */
	public String getArtistSearchResult(String artistName)
	{
		return (String) artistSearchResults.get(artistName);
	}
}