// copyright 2001-2002 by The Mind Electric

package electric.xml.xpath;

import electric.xml.*;

/**
 * <tt>IndexPredicate</tt> processes XPath "[n]" and "name[n]" sub-expressions.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class IndexPredicate extends NameNode
  {
  private int index;

  // ********** CONSTRUCTION ************************************************

  /**
   * @param string
   * @throws XPathException
   */
  public IndexPredicate( String string )
    throws XPathException
    {
    int openBracket = string.indexOf( '[' );

    if( openBracket > 0 )
      setName( string.substring( 0, openBracket ) );

    int closeBracket = string.indexOf( ']' );

    if( closeBracket == -1 )
      throw new XPathException( "missing ] in " + string );

    index = Integer.parseInt( string.substring( openBracket + 1, closeBracket ) );
    }

  // ********** MATCHING ****************************************************

  /**
   * @param xpath
   * @param node
   * @param list
   * @throws XPathException
   */
  public void addNodes( TMEXPath xpath, Node node, NodeList list )
    throws XPathException
    {
    if( name == null )
      {
      addNextNodes( xpath, ((Parent) node).getElementAt( index ), list );
      return;
      }

    int i = 0;

    for( Elements elements = ((Parent) node).getElements(); elements.hasMoreElements(); )
      {
      Element element = elements.next();

      if( element.hasName( getNamespace( xpath, element ), name ) && ++i == index )
        {
        addNextNodes( xpath, element, list );
        return;
        }
      }

    throw new IndexOutOfBoundsException( index + " is an invalid index" );
    }
  }