// copyright 2001-2002 by The Mind Electric
// based on source code contributed by the jaxen group, http://www.jaxen.org

package electric.xml.jaxen;

import java.util.*;
import electric.xml.*;

/**
 * <tt>NamespaceIterator</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class NamespaceIterator extends AttributesIterator
  {
  // ********** CONSTRUCTION ************************************************

  /**
   * @param attributes
   */
  public NamespaceIterator( Attributes attributes )
    {
    super( attributes );
    }

  // ********** VALIDITY CHECKING *******************************************

  /**
   * @param attribute
   * @return true if this node is valid - i.e. the attribute starts with xmlns
   */
  protected boolean validNode( Attribute attribute )
    {
    String name = attribute.toString();
    return (name != null && name.startsWith( "xmlns" ));
    }
  }