// copyright 2001-2002 by The Mind Electric
// based on source code contributed by the jaxen group, http://www.jaxen.org

package electric.xml.jaxen;

import electric.xml.*;
import java.util.*;

/**
 * <tt>ChildrenIterator</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class ChildrenIterator implements Iterator
  {
  private Children children;

  // ********** CONSTRUCTION ************************************************

  /**
   * @param children
   */
  public ChildrenIterator( Children children )
    {
    this.children = children;
    }

  // ********** ITERATOR METHODS ********************************************

  /**
   *
   */
  public boolean hasNext()
    {
    return (children.current() != null);
    }

  /**
   * @throws NoSuchElementException
   */
  public Object next()
    throws NoSuchElementException
    {
    if( !hasNext() )
      throw new NoSuchElementException();

    return this.children.next();
    }

  /**
   * @throws UnsupportedOperationException
   */
  public void remove()
    throws UnsupportedOperationException
    {
    throw new UnsupportedOperationException();
    }
  }