// copyright 2001-2002 by The Mind Electric

package electric.xml;

import java.io.*;

/**
 * <tt>Selection</tt> represents a node that was selected by an XPath
 * operation. It overrides getNode() so that when you attempt to remove
 * a selected node, it removes the node that it points to instead.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

final public class Selection extends Node
  {
  private Node node; // the selected node

  // ********** CONSTRUCTION ************************************************

  /**
   * Construct a Selection associated with the specified node.
   * @param node The Node.
   */
  public Selection( Node node )
    {
    this.node = node;
    }

  /**
   * Construct a copy of the specified selection.
   * @param selection The Selection to copy.
   */
  public Selection( Selection selection )
    {
    this.node = selection.node;
    }

  // ********** CLONING *****************************************************

  /**
   * Return a clone of this Selection.
   */
  public Object clone()
    {
    return new Selection( this );
    }

  // ********** NODE ********************************************************

  /**
   * Return the selected node that I represent.
   */
  public Node getNode()
    {
    return node;
    }
  }