// copyright 2001-2002 by The Mind Electric

package electric.xml;

import java.io.*;
import electric.util.*;

/**
 * <tt>NotationDecl</tt> represents an XML NOTATION declaration.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

final public class NotationDecl extends Child
  {
  static final String START = "<!NOTATION";
  static final String STOP = ">";

  private String content;

  // ********** CONSTRUCTION ************************************************

  /**
   * Construct an NotationDecl with the specified content.
   * @param content The content.
   */
  public NotationDecl( String content )
    {
    this.content = content;
    }

  /**
   * Construct a copy of the specified NotationDecl.
   * @param notationDecl The NotationDecl to copy.
   */
  public NotationDecl( NotationDecl notationDecl )
    {
    this.content = notationDecl.content;
    }

  /**
   * Construct a NotationDecl from the specified lexical analyzer.
   * @param lex The lexical analyzer.
   * @param parent The parent of this NotationDecl.
   * @throws IOException If an error occurs during parsing.
   */
  NotationDecl( Lex lex, Parent parent )
    throws IOException
    {
    super( parent );
    lex.skip( START.length() );
    String token = lex.readToPattern( STOP, Lex.CONSUME | Lex.INCLUDE | Lex.QUOTES );
    content = token.substring( 0, token.length() - STOP.length() );
    }

  // ********** CLONING *****************************************************

  /**
   * Return a clone of this NotationDecl.
   */
  public Object clone()
    {
    return new NotationDecl( this );
    }

  // ********** CONTENT *****************************************************

  /**
   * Return my content.
   */
  public String getContent()
    {
    return content;
    }

  /**
   * Set my content.
   * @param content The new content value.
   */
  public void setContent( String content )
    {
    this.content = content;
    }

  // ********** WRITING *****************************************************

  /**
   * Write myself to the specified writer.
   * @param writer The nodeWriter.
   * @throws IOException If an I/O exception occurs.
   */
  public void write( NodeWriter writer )
    throws IOException
    {
    writer.writeIndent();
    writer.write( START );
    writer.write( content );
    writer.write( STOP );
    }
  }