// copyright 2001-2002 by The Mind Electric

package electric.xml;

/**
 * <tt>ElementsFilter</tt> is an enumeration over a collection of elements.
 * To iterate through the collection in a typesafe way, use current(), first() and next().
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

final class ElementsFilter extends Elements
  {
  // ********** CONSTRUCTION ************************************************

  /**
   * Construct an ElementsFilter associated with the specified node list.
   * @param list The list, some of which are Element nodes.
   */
  ElementsFilter( NodeList list )
    {
    super( list );
    }

  // ********** OVERRIDES FOR FILTERING *************************************

  /**
   * Move to the first Element.
   */
  public void reset()
    {
    super.reset();

    while( current != null && !(current.getNode() instanceof Element) )
      current = current.next;
    }

  /**
   * Move to the first Element and return it, or null if there is none.
   */
  public Node nextNode()
    {
    if( current == null )
      return null;

    Node node = current.getNode();

    do
      {
      current = current.next;
      }
    while( current != null && !(current.getNode() instanceof Element) );

    return node;
    }

  /**
   * Return the number of Elements in the list.
   */
  public int size()
    {
    int count = 0;

    for( Node node = list.first; node != null; node = node.next )
      if( node.getNode() instanceof Element )
        ++count;

    return count;
    }
  }