// copyright 2001-2002 by The Mind Electric

package electric.util.reflect;

import java.util.*;

/**
 * <tt>Wrappers</tt>.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public final class Wrappers
  {
  private static final Hashtable wrapperToPrimitive = new Hashtable();
  private static final Hashtable primitiveToWrapper = new Hashtable();

  // ********** INITIALIZATION **********************************************

  static
    {
    initWrappers();
    }

  // ********** PRIMITIVE/WRAPPER MAPPINGS **********************************

  /**
   *
   */
  private static void initWrappers()
    {
    addWrapper( Integer.TYPE, Integer.class );
    addWrapper( Byte.TYPE, Byte.class );
    addWrapper( Short.TYPE, Short.class );
    addWrapper( Long.TYPE, Long.class );
    addWrapper( Float.TYPE, Float.class );
    addWrapper( Double.TYPE, Double.class );
    addWrapper( Boolean.TYPE, Boolean.class );
    addWrapper( Character.TYPE, Character.class );
    }

  /**
   * @param primitive
   * @param wrapper
   */
  private static void addWrapper( Class primitive, Class wrapper )
    {
    primitiveToWrapper.put( primitive, wrapper );
    wrapperToPrimitive.put( wrapper, primitive );
    }

  /**
   * @param primitive
   */
  public static Class getWrapperClass( Class primitive )
    {
    return (Class) primitiveToWrapper.get( primitive );
    }

  /**
   * @param wrapper
   */
  public static Class getPrimitiveClass( Class wrapper )
    {
    return (Class) wrapperToPrimitive.get( wrapper );
    }

  /**
   * @param className
   */
  public static Class getPrimitiveClass( String className )
    {
    for( Enumeration enum = primitiveToWrapper.keys(); enum.hasMoreElements(); )
      {
      Class javaClass = (Class) enum.nextElement();

      if( javaClass.getName().equalsIgnoreCase( className ) )
        return javaClass;
      }

    return null;
    }
  }