// copyright 2001-2002 by The Mind Electric

package electric.util.interceptor;

import java.io.*;
import electric.util.*;
import electric.xml.*;
import electric.xml.io.*;
import electric.xml.io.encoded.*;
import electric.xml.io.literal.*;
import electric.soap.*;

/**
 * <tt>SendThreadContext</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class SendThreadContext implements ISOAPInterceptor
  {
  private String name;
  private boolean encoded;

  // ********** CONSTRUCTION ************************************************

  /**
   * @param name
   */
  public SendThreadContext( String name )
    {
    this( name, true );
    }

  /**
   * @param name
   * @param encoded
   */
  public SendThreadContext( String name, boolean encoded )
    {
    this.name = name;
    this.encoded = encoded;
    }

  // ********** NAME ********************************************************

  /**
   *
   */
  public String getName()
    {
    return name;
    }

  /**
   * @param name
   */
  public void setName( String name )
    {
    this.name = name;
    }

  // ********** ENCODED/LITERAL *********************************************

  /**
   *
   */
  public boolean getEncoded()
    {
    return encoded;
    }

  /**
   * @param encoded
   */
  public void setEncoded( boolean encoded )
    {
    this.encoded = encoded;
    }

  // ********** INTERCEPT ***************************************************

  /**
   * @param message
   * @param context
   */
  public void intercept( SOAPMessage message, Context context )
    {
    Object property = Context.thread().getProperty( name );
    Element headerElement = new Element( name );
    IWriter writer = null;

    if( encoded )
      writer = new EncodedWriter( headerElement );
    else
      writer = new LiteralWriter( headerElement );

    try
      {
      writer.writeObject( property );
      }
    catch( IOException exception )
      {
      message.setException( exception );
      }

    message.addHeaderElement( headerElement );
    }
  }