/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.renderer.common.MetadataAdministrator;

import javax.swing.BorderFactory;
import javax.swing.*;
import javax.swing.event.DocumentListener;
import javax.swing.event.DocumentEvent;
import java.awt.*;

public class MetadataEditorPageGeneral extends JAPanel {
    private final MetadataEditor theEditor;
    JSpinner spnVersionNumber = new JSpinner();
    JSpinner spnRevisionNumber = new JSpinner();
    JSpinner spnSubrevisionNumber = new JSpinner();
    JSpinner spnBuildNumber = new JSpinner();
    JATextField txtDesignBorderDefinition = new JATextField();
    JATextArea txtComments = new JATextArea();

    public MetadataEditorPageGeneral (MetadataEditor editor) {
        super();
        this.theEditor = editor;
        initInterface();
        populateInterface();
    }

    void populateInterface () {
        MetadataAdministrator admin = theEditor.theMetadataDispenser.theMetaDataAdministrator;
        spnVersionNumber.setModel(new SpinnerNumberModel(admin.iVersionNumber, 0, 999, 1));
        spnRevisionNumber.setModel(new SpinnerNumberModel(admin.iRevisionNumber, 0, 999, 1));
        spnSubrevisionNumber.setModel(new SpinnerNumberModel(admin.iSubrevisionNumber, 0, 999, 1));
        spnBuildNumber.setModel(new SpinnerNumberModel(admin.iBuildNumber, 0, 999, 1));
        txtDesignBorderDefinition.setText(theEditor.theMetadataDispenser.sDesignBorderDefinition);
        txtComments.setText(theEditor.theMetadataDispenser.theMetadataDocument.sDocumentComments);
    }

    void initInterface () {
        setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

        setLayout(new BorderLayout());

        JAPanel pnlTopNonVisible = new JAPanel(new BorderLayout()); // this will hold the version + design border
        JAPanel pnlCenterNonVisible = new JAPanel(new BorderLayout()); // this will hold the comments

        JAPanel pnlVersion = new JAPanel();
        pnlVersion.setBorder(BorderFactory.createTitledBorder("Version Numbers"));

        JAPanel pnlVersionNumber = new JAPanel();
        JALabel lblVersionNumber = new JALabel("Version");
        spnVersionNumber.setPreferredSize(new Dimension(60, 22));
        pnlVersionNumber.add(lblVersionNumber);
        pnlVersionNumber.add(spnVersionNumber);
        pnlVersion.add(pnlVersionNumber);

        JAPanel pnlRevisionNumber = new JAPanel();
        JALabel lblRevisionNumber = new JALabel("Revision", JLabel.RIGHT);
        spnRevisionNumber.setPreferredSize(new Dimension(60, 22));
        pnlRevisionNumber.add(lblRevisionNumber);
        pnlRevisionNumber.add(spnRevisionNumber);
        pnlVersion.add(pnlRevisionNumber);

        JAPanel pnlSubrevisionNumber = new JAPanel();
        JALabel lblSubrevisionNumber = new JALabel("Subrevision", JLabel.RIGHT);
        spnSubrevisionNumber.setPreferredSize(new Dimension(60, 22));
        pnlSubrevisionNumber.add(lblSubrevisionNumber);
        pnlSubrevisionNumber.add(spnSubrevisionNumber);
        pnlVersion.add(pnlSubrevisionNumber);

        JAPanel pnlBuildNumber = new JAPanel();
        JALabel lblBuildNumber = new JALabel("Build", JLabel.RIGHT);
        spnBuildNumber.setPreferredSize(new Dimension(60, 22));
        pnlBuildNumber.add(lblBuildNumber);
        pnlBuildNumber.add(spnBuildNumber);
        pnlVersion.add(pnlBuildNumber);

        JAPanel pnlDesignBorderDefinition = new JAPanel(new BorderLayout());
        pnlDesignBorderDefinition.setBorder(BorderFactory.createTitledBorder("Design-Border Definition"));

        JAPanel pnlComments = new JAPanel(new BorderLayout());
        pnlComments.setBorder(BorderFactory.createTitledBorder("Comments"));
        pnlComments.add(new JAScrollPane(txtComments), BorderLayout.CENTER);


        pnlDesignBorderDefinition.add(txtDesignBorderDefinition, BorderLayout.NORTH);

        pnlTopNonVisible.add(pnlVersion, BorderLayout.NORTH);
        pnlTopNonVisible.add(pnlDesignBorderDefinition, BorderLayout.CENTER);

        pnlCenterNonVisible.add(pnlComments, BorderLayout.CENTER);

        this.add(pnlTopNonVisible, BorderLayout.NORTH);
        this.add(pnlCenterNonVisible, BorderLayout.CENTER);
        //JAPanel blank = new JAPanel(new BorderLayout());
        //blank.add(pnlDesignBorderDefinition, BorderLayout.NORTH);
        //this.add(blank);
        //this.add(pnlComments);

        DocumentListener documentListener = new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                theEditor.setMetadataModified(true);
            }

            public void insertUpdate(DocumentEvent e) {
                if (theEditor.isVisible())
                    theEditor.setMetadataModified(true);
            }

            public void removeUpdate(DocumentEvent e) {
                theEditor.setMetadataModified(true);
            }
        } ;

        txtComments.getDocument().addDocumentListener(documentListener);
        txtDesignBorderDefinition.getDocument().addDocumentListener(documentListener);

    }

    public void save () {
        int iVersionNumber = ((Integer) spnVersionNumber.getValue()).intValue();
        int iRevisionNumber = ((Integer) spnRevisionNumber.getValue()).intValue();
        int iSubrevisionNumber = ((Integer) spnSubrevisionNumber.getValue()).intValue();
        int iBuildNumber = ((Integer) spnBuildNumber.getValue()).intValue();

        String sDesignBorderDefinition = txtDesignBorderDefinition.getText();

        theEditor.theMetadataDispenser.theMetaDataAdministrator.iVersionNumber = iVersionNumber;
        theEditor.theMetadataDispenser.theMetaDataAdministrator.iRevisionNumber = iRevisionNumber;
        theEditor.theMetadataDispenser.theMetaDataAdministrator.iSubrevisionNumber = iSubrevisionNumber;
        theEditor.theMetadataDispenser.theMetaDataAdministrator.iBuildNumber = iBuildNumber;

        theEditor.theMetadataDispenser.sDesignBorderDefinition = sDesignBorderDefinition;

        String sComments = txtComments.getText();
        if (sComments.length() == 0) sComments = null;
        theEditor.theMetadataDispenser.theMetadataDocument.sDocumentComments = sComments;

    }
}

