/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.lib.ui.JAMenu;
import ch.abacus.lib.ui.JAMenuBar;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Nov 15, 2004
 * Time: 7:10:52 PM
 */
public class MenuBar extends JAMenuBar {
    private final ActionManager theActionManager;

    public MenuBar (ActionManager actionManager) {
        theActionManager = actionManager;
        createInterface();
    }

    private void createInterface() {
        JAMenu fileMenu = new JAMenu("File");
        JAMenu helpMenu = new JAMenu("Help");

        // file menu...
        fileMenu.add(theActionManager.getSaveAction());
        fileMenu.addSeparator();
        fileMenu.add(theActionManager.getExitAction());
        add(fileMenu);

        // Help menu...
        helpMenu.add(theActionManager.getAboutAction());
        add(helpMenu);
    }


}
